/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.junit;

import java.util.function.Supplier;
import org.junit.jupiter.api.function.Executable;
import org.springframework.core.NestedExceptionUtils;

public class Assertions {
    public static <T extends Throwable> void assertHasRootCause(Class<? extends Throwable> expectedClass, T actual) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expectedClass.isInstance(NestedExceptionUtils.getRootCause(actual)));
    }

    public static <T extends Throwable> T assertThrowsWithRootCause(Class<T> expectedType, Class<? extends Throwable> expectedRootType, Executable executable) {
        Throwable exception = org.junit.jupiter.api.Assertions.assertThrows(expectedType, (Executable)executable);
        Assertions.assertHasRootCause(expectedRootType, exception);
        return (T)exception;
    }

    public static <T extends Throwable> T assertThrowsOrNot(T expected, Executable executable) {
        if (expected == null) {
            org.junit.jupiter.api.Assertions.assertDoesNotThrow((Executable)executable);
            return null;
        }
        return (T)org.junit.jupiter.api.Assertions.assertThrows(expected.getClass(), (Executable)executable);
    }

    public static <T extends Throwable> T assertThrowsOrNot(T expected, Executable executable, String message) {
        if (expected == null) {
            org.junit.jupiter.api.Assertions.assertDoesNotThrow((Executable)executable, (String)message);
            return null;
        }
        return (T)org.junit.jupiter.api.Assertions.assertThrows(expected.getClass(), (Executable)executable, (String)message);
    }

    public static <T extends Throwable> T assertThrowsOrNot(T expected, Executable executable, Supplier<String> messageSupplier) {
        if (expected == null) {
            org.junit.jupiter.api.Assertions.assertDoesNotThrow((Executable)executable, messageSupplier);
            return null;
        }
        return (T)org.junit.jupiter.api.Assertions.assertThrows(expected.getClass(), (Executable)executable, messageSupplier);
    }
}

