/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.junit;

import java.lang.reflect.AnnotatedElement;
import org.apereo.cas.util.SocketUtils;
import org.apereo.cas.util.junit.EnabledIfPortOpen;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class EnabledIfPortOpenCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled((String)"@EnabledIfPortOpen is not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext extensionContext) {
        AnnotatedElement element = (AnnotatedElement)extensionContext.getElement().orElseThrow(IllegalStateException::new);
        return AnnotationSupport.findAnnotation((AnnotatedElement)element, EnabledIfPortOpen.class).map(annotation -> EnabledIfPortOpenCondition.enableIfOpen(annotation, element)).orElse(ENABLED_BY_DEFAULT);
    }

    private static ConditionEvaluationResult enableIfOpen(EnabledIfPortOpen annotation, AnnotatedElement element) {
        int port = annotation.port();
        if (port <= 0) {
            throw new IllegalArgumentException("Port must be positive.");
        }
        if (SocketUtils.isTcpPortAvailable((int)port)) {
            return ConditionEvaluationResult.disabled((String)String.format("%s is disabled because %s is not in use", element, port));
        }
        return ConditionEvaluationResult.enabled((String)String.format("%s is enabled because %s is open.", element, port));
    }
}

