/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support.filters;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apereo.cas.web.support.filters.AbstractSecurityFilter;
import org.apereo.cas.web.support.filters.RequestParameterPolicyEnforcementFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class RequestParameterPolicyEnforcementFilterTests {
    private static void internalTestOnlyPostParameter(String method) {
        HashSet<String> onlyPostParameters = new HashSet<String>();
        onlyPostParameters.add("username");
        onlyPostParameters.add("password");
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("username", new String[]{"jle"});
        RequestParameterPolicyEnforcementFilter.checkOnlyPostParameters((String)method, parameterMap, onlyPostParameters);
    }

    @BeforeEach
    public void setup() {
        RequestParameterPolicyEnforcementFilter.setThrowOnErrors((boolean)true);
    }

    @Test
    public void verifyUnrecognizedInitParamFailsFilterInit() {
        MockFilterConfig filterConfig = new MockFilterConfig();
        filterConfig.addInitParameter("unrecognizedInitParameterName", "whatever");
        RequestParameterPolicyEnforcementFilter filter = new RequestParameterPolicyEnforcementFilter();
        Assertions.assertThrows(RuntimeException.class, () -> filter.init((FilterConfig)filterConfig));
    }

    @Test
    public void verifyNoOpConfigurationFailsFilterInit() {
        RequestParameterPolicyEnforcementFilter filter = new RequestParameterPolicyEnforcementFilter();
        HashSet<String> initParameterNames = new HashSet<String>();
        initParameterNames.add("allowMultiValuedParameters");
        initParameterNames.add("charactersToForbid");
        Enumeration parameterNamesEnumeration = Collections.enumeration(initParameterNames);
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameterNames()).thenReturn(parameterNamesEnumeration);
        Mockito.when((Object)filterConfig.getInitParameter("allowMultiValuedParameters")).thenReturn((Object)"true");
        Mockito.when((Object)filterConfig.getInitParameter("charactersToForbid")).thenReturn((Object)"none");
        Mockito.when((Object)filterConfig.getInitParameter("parametersToCheck")).thenReturn(null);
        Assertions.assertThrows(RuntimeException.class, () -> filter.init(filterConfig));
    }

    @Test
    public void verifySettingFailSafeTrueFromInitParam() {
        RequestParameterPolicyEnforcementFilter filter = new RequestParameterPolicyEnforcementFilter();
        HashSet<String> initParameterNames = new HashSet<String>();
        initParameterNames.add("failSafe");
        Enumeration parameterNamesEnumeration = Collections.enumeration(initParameterNames);
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameterNames()).thenReturn(parameterNamesEnumeration);
        Mockito.when((Object)filterConfig.getInitParameter("failSafe")).thenReturn((Object)"true");
        filter.init(filterConfig);
        Assertions.assertTrue((boolean)AbstractSecurityFilter.isThrowOnErrors());
    }

    @Test
    public void verifySettingFailSafeFalseFromInitParam() throws Exception {
        RequestParameterPolicyEnforcementFilter filter = new RequestParameterPolicyEnforcementFilter();
        HashSet<String> initParameterNames = new HashSet<String>();
        initParameterNames.add("failSafe");
        Enumeration parameterNamesEnumeration = Collections.enumeration(initParameterNames);
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameterNames()).thenReturn(parameterNamesEnumeration);
        Mockito.when((Object)filterConfig.getInitParameter("failSafe")).thenReturn((Object)"false");
        filter.init(filterConfig);
        Assertions.assertFalse((boolean)AbstractSecurityFilter.isThrowOnErrors());
    }

    @Test
    public void verifyRejectsMultiValuedRequestParameter() {
        RequestParameterPolicyEnforcementFilter filter = new RequestParameterPolicyEnforcementFilter();
        HashSet initParameterNames = new HashSet();
        Enumeration parameterNamesEnumeration = Collections.enumeration(initParameterNames);
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameterNames()).thenReturn(parameterNamesEnumeration);
        Mockito.when((Object)filterConfig.getInitParameter("allowMultiValuedParameters")).thenReturn(null);
        Mockito.when((Object)filterConfig.getInitParameter("charactersToForbid")).thenReturn(null);
        Mockito.when((Object)filterConfig.getInitParameter("parametersToCheck")).thenReturn(null);
        try {
            filter.init(filterConfig);
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not have failed filter init.");
        }
        HashMap<String, String[]> requestParameterMap = new HashMap<String, String[]>();
        requestParameterMap.put("someName", new String[]{"someValue", "someOtherValue"});
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameters(requestParameterMap);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        Assertions.assertThrows(RuntimeException.class, () -> filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain));
    }

    @Test
    public void verifyAcceptsMultiValuedRequestParameter() throws IOException, ServletException {
        RequestParameterPolicyEnforcementFilter filter = new RequestParameterPolicyEnforcementFilter();
        HashSet<String> initParameterNames = new HashSet<String>();
        initParameterNames.add("allowMultiValuedParameters");
        Enumeration parameterNamesEnumeration = Collections.enumeration(initParameterNames);
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameterNames()).thenReturn(parameterNamesEnumeration);
        Mockito.when((Object)filterConfig.getInitParameter("allowMultiValuedParameters")).thenReturn((Object)"true");
        Mockito.when((Object)filterConfig.getInitParameter("charactersToForbid")).thenReturn(null);
        Mockito.when((Object)filterConfig.getInitParameter("parametersToCheck")).thenReturn(null);
        try {
            filter.init(filterConfig);
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not have failed filter init.");
        }
        HashMap<String, String[]> requestParameterMap = new HashMap<String, String[]>();
        requestParameterMap.put("someName", new String[]{"someValue", "someOtherValue"});
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameters(requestParameterMap);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
    }

    @Test
    public void verifyRejectsRequestWithIllicitCharacterInCheckedParameter() throws IOException, ServletException {
        RequestParameterPolicyEnforcementFilter filter = new RequestParameterPolicyEnforcementFilter();
        HashSet initParameterNames = new HashSet();
        Enumeration parameterNamesEnumeration = Collections.enumeration(initParameterNames);
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameterNames()).thenReturn(parameterNamesEnumeration);
        Mockito.when((Object)filterConfig.getInitParameter("allowMultiValuedParameters")).thenReturn(null);
        Mockito.when((Object)filterConfig.getInitParameter("charactersToForbid")).thenReturn(null);
        Mockito.when((Object)filterConfig.getInitParameter("parametersToCheck")).thenReturn(null);
        try {
            filter.init(filterConfig);
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not have failed filter init.");
        }
        HashMap<String, String[]> requestParameterMap = new HashMap<String, String[]>();
        requestParameterMap.put("someName", new String[]{"someValue%40gmail.com"});
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameters(requestParameterMap);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        Assertions.assertThrows(RuntimeException.class, () -> filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain));
    }

    @Test
    public void verifyAllowsUncheckedParametersToHaveIllicitCharacters() throws IOException, ServletException {
        RequestParameterPolicyEnforcementFilter filter = new RequestParameterPolicyEnforcementFilter();
        HashSet<String> initParameterNames = new HashSet<String>();
        initParameterNames.add("parametersToCheck");
        Enumeration parameterNamesEnumeration = Collections.enumeration(initParameterNames);
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameterNames()).thenReturn(parameterNamesEnumeration);
        Mockito.when((Object)filterConfig.getInitParameter("allowMultiValuedParameters")).thenReturn(null);
        Mockito.when((Object)filterConfig.getInitParameter("charactersToForbid")).thenReturn(null);
        Mockito.when((Object)filterConfig.getInitParameter("parametersToCheck")).thenReturn((Object)"ticket");
        try {
            filter.init(filterConfig);
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not have failed filter init.");
        }
        HashMap<String, String[]> requestParameterMap = new HashMap<String, String[]>();
        requestParameterMap.put("uncheckedName", new String[]{"someValue%40gmail.com"});
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameters(requestParameterMap);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
    }

    @Test
    public void verifyAcceptsExpectedParameterNames() {
        HashSet<String> parameterNames = new HashSet<String>();
        parameterNames.add("charactersToForbid");
        parameterNames.add("parametersToCheck");
        parameterNames.add("allowMultiValuedParameters");
        Enumeration parameterNamesEnumeration = Collections.enumeration(parameterNames);
        RequestParameterPolicyEnforcementFilter.throwIfUnrecognizedParamName(parameterNamesEnumeration);
    }

    @Test
    public void verifyRejectsUnExpectedParameterName() throws ServletException {
        HashSet<String> parameterNames = new HashSet<String>();
        parameterNames.add("charactersToForbid");
        parameterNames.add("parametersToCheck");
        parameterNames.add("allowMultiValuedParameters");
        parameterNames.add("unexpectedParameterName");
        Enumeration parameterNamesEnumeration = Collections.enumeration(parameterNames);
        Assertions.assertThrows(RuntimeException.class, () -> RequestParameterPolicyEnforcementFilter.throwIfUnrecognizedParamName((Enumeration)parameterNamesEnumeration));
    }

    @Test
    public void verifyParsesNullToEmptySet() {
        Set returnedSet = RequestParameterPolicyEnforcementFilter.parseParametersList(null, (boolean)true);
        Assertions.assertTrue((boolean)returnedSet.isEmpty());
    }

    @Test
    public void verifyParsesWhiteSpaceDelimitedStringToSet() {
        String parameterValue = "service renew gateway";
        HashSet<String> expectedSet = new HashSet<String>();
        expectedSet.add("service");
        expectedSet.add("renew");
        expectedSet.add("gateway");
        Set returnedSet = RequestParameterPolicyEnforcementFilter.parseParametersList((String)"service renew gateway", (boolean)true);
        Assertions.assertEquals(expectedSet, (Object)returnedSet);
    }

    @Test
    public void verifyParsingBlankParametersToCheckThrowsException() {
        Assertions.assertThrows(Exception.class, () -> RequestParameterPolicyEnforcementFilter.parseParametersList((String)"   ", (boolean)true));
    }

    @Test
    public void verifyAsteriskParsesIfAllowedToEmptySetOfParametersToCheck() {
        HashSet expectedSet = new HashSet();
        Set returnedSet = RequestParameterPolicyEnforcementFilter.parseParametersList((String)"*", (boolean)true);
        Assertions.assertEquals(expectedSet, (Object)returnedSet);
    }

    @Test
    public void verifyAsteriskParseIfNotAllowedThrowsException() {
        Assertions.assertThrows(Exception.class, () -> RequestParameterPolicyEnforcementFilter.parseParametersList((String)"*", (boolean)false));
    }

    @Test
    public void verifyParsingAsteriskWithOtherTokensThrowsException() {
        Assertions.assertThrows(Exception.class, () -> RequestParameterPolicyEnforcementFilter.parseParametersList((String)"renew * gateway", (boolean)true));
    }

    @Test
    public void verifyParsingNullYieldsPercentHashAmpersandAndQuestionMark() {
        HashSet<Character> expected = new HashSet<Character>();
        expected.add(Character.valueOf('%'));
        expected.add(Character.valueOf('#'));
        expected.add(Character.valueOf('&'));
        expected.add(Character.valueOf('?'));
        Set actual = RequestParameterPolicyEnforcementFilter.parseCharactersToForbid(null);
        Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    public void verifyParsingBlankThrowsException() {
        Assertions.assertThrows(Exception.class, () -> RequestParameterPolicyEnforcementFilter.parseCharactersToForbid((String)"   "));
    }

    @Test
    public void verifyParsesLiteralNoneToEmptySet() {
        HashSet expected = new HashSet();
        Set actual = RequestParameterPolicyEnforcementFilter.parseCharactersToForbid((String)"none");
        Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    public void verifyParsingSomeCharactersWorks() {
        HashSet<Character> expected = new HashSet<Character>();
        expected.add(Character.valueOf('&'));
        expected.add(Character.valueOf('%'));
        expected.add(Character.valueOf('*'));
        expected.add(Character.valueOf('#'));
        expected.add(Character.valueOf('@'));
        Set actual = RequestParameterPolicyEnforcementFilter.parseCharactersToForbid((String)"& % * # @");
        Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    public void verifyParsingMulticharacterTokensThrows() {
        Assertions.assertThrows(Exception.class, () -> RequestParameterPolicyEnforcementFilter.parseCharactersToForbid((String)"& %*# @"));
    }

    @Test
    public void verifyRequireNotMultiValueBlocksMultiValue() {
        HashSet<String> parametersToCheck = new HashSet<String>();
        parametersToCheck.add("dogName");
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("dogName", new String[]{"Johan", "Cubby"});
        Assertions.assertThrows(RuntimeException.class, () -> RequestParameterPolicyEnforcementFilter.requireNotMultiValued((Set)parametersToCheck, (Map)parameterMap));
    }

    @Test
    public void verifyRequireNotMultiValuedAllowsSingleValued() {
        HashSet<String> parametersToCheck = new HashSet<String>();
        parametersToCheck.add("dogName");
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("dogName", new String[]{"Abbie"});
        RequestParameterPolicyEnforcementFilter.requireNotMultiValued(parametersToCheck, parameterMap);
    }

    @Test
    public void verifyRequireNotMultiValuedIgnoresMissingParameter() {
        HashSet<String> parametersToCheck = new HashSet<String>();
        parametersToCheck.add("dogName");
        HashMap parameterMap = new HashMap();
        RequestParameterPolicyEnforcementFilter.requireNotMultiValued(parametersToCheck, parameterMap);
    }

    @Test
    public void verifyRequireNotMultiValueAllowsUncheckedMultiValue() {
        HashSet<String> parametersToCheck = new HashSet<String>();
        parametersToCheck.add("dogName");
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("catName", new String[]{"Reggie", "Shenanigans"});
        RequestParameterPolicyEnforcementFilter.requireNotMultiValued(parametersToCheck, parameterMap);
    }

    @Test
    public void verifyAllowsParametersNotContainingForbiddenCharacters() {
        HashSet<String> parametersToCheck = new HashSet<String>();
        parametersToCheck.add("catName");
        parametersToCheck.add("dogName");
        HashSet<Character> charactersToForbid = new HashSet<Character>();
        charactersToForbid.add(Character.valueOf('&'));
        charactersToForbid.add(Character.valueOf('%'));
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("catName", new String[]{"Reggie", "Shenanigans"});
        parameterMap.put("dogName", new String[]{"Brutus", "Johan", "Cubby", "Abbie"});
        parameterMap.put("plantName", new String[]{"Rex"});
        RequestParameterPolicyEnforcementFilter.enforceParameterContentCharacterRestrictions(parametersToCheck, charactersToForbid, parameterMap);
    }

    @Test
    public void verifyThrowsOnParameterContainingForbiddenCharacter() {
        HashSet<String> parametersToCheck = new HashSet<String>();
        parametersToCheck.add("catName");
        parametersToCheck.add("plantName");
        HashSet<Character> charactersToForbid = new HashSet<Character>();
        charactersToForbid.add(Character.valueOf('&'));
        charactersToForbid.add(Character.valueOf('%'));
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("catName", new String[]{"Reggie", "Shenanigans"});
        parameterMap.put("dogName", new String[]{"Brutus", "Johan", "Cubby", "Abbie"});
        parameterMap.put("plantName", new String[]{"Rex&p0wned=true"});
        Assertions.assertThrows(Exception.class, () -> RequestParameterPolicyEnforcementFilter.enforceParameterContentCharacterRestrictions((Set)parametersToCheck, (Set)charactersToForbid, (Map)parameterMap));
    }

    @Test
    public void verifyThrowsOnMultipleParameterContainingForbiddenCharacter() {
        HashSet<String> parametersToCheck = new HashSet<String>();
        parametersToCheck.add("catName");
        parametersToCheck.add("dogName");
        HashSet<Character> charactersToForbid = new HashSet<Character>();
        charactersToForbid.add(Character.valueOf('!'));
        charactersToForbid.add(Character.valueOf('$'));
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("catName", new String[]{"Reggie", "Shenanigans"});
        parameterMap.put("dogName", new String[]{"Brutus", "Johan", "Cub!by", "Abbie"});
        parameterMap.put("plantName", new String[]{"Rex"});
        Assertions.assertThrows(Exception.class, () -> RequestParameterPolicyEnforcementFilter.enforceParameterContentCharacterRestrictions((Set)parametersToCheck, (Set)charactersToForbid, (Map)parameterMap));
    }

    @Test
    public void verifyAllowsUncheckedParameterContainingForbiddenCharacter() {
        HashSet<String> parametersToCheck = new HashSet<String>();
        parametersToCheck.add("catName");
        parametersToCheck.add("dogName");
        HashSet<Character> charactersToForbid = new HashSet<Character>();
        charactersToForbid.add(Character.valueOf('&'));
        charactersToForbid.add(Character.valueOf('$'));
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("catName", new String[]{"Reggie", "Shenanigans"});
        parameterMap.put("dogName", new String[]{"Brutus", "Johan", "Cubby", "Abbie"});
        parameterMap.put("plantName", new String[]{"Rex&ownage=true"});
        RequestParameterPolicyEnforcementFilter.enforceParameterContentCharacterRestrictions(parametersToCheck, charactersToForbid, parameterMap);
    }

    @Test
    public void verifyAllowsCheckedParameterNotPresent() {
        HashSet<String> parametersToCheck = new HashSet<String>();
        parametersToCheck.add("catName");
        parametersToCheck.add("dogName");
        HashSet<Character> charactersToForbid = new HashSet<Character>();
        charactersToForbid.add(Character.valueOf('&'));
        charactersToForbid.add(Character.valueOf('$'));
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("dogName", new String[]{"Brutus", "Johan", "Cubby", "Abbie"});
        RequestParameterPolicyEnforcementFilter.enforceParameterContentCharacterRestrictions(parametersToCheck, charactersToForbid, parameterMap);
    }

    @Test
    public void verifyOnlyPostParameterInPostRequest() {
        RequestParameterPolicyEnforcementFilterTests.internalTestOnlyPostParameter("POST");
    }

    @Test
    public void verifyOnlyPostParameterInGetRequest() {
        Assertions.assertThrows(Exception.class, () -> RequestParameterPolicyEnforcementFilterTests.internalTestOnlyPostParameter("GET"));
    }

    @Test
    public void verifyBlocksRequestByPattern() throws Exception {
        RequestParameterPolicyEnforcementFilter filter = new RequestParameterPolicyEnforcementFilter();
        MockFilterConfig filterConfig = new MockFilterConfig();
        filterConfig.addInitParameter("patternToBlock", ".+example\\.(com|org).*#fragment$");
        filter.init((FilterConfig)filterConfig);
        HashMap<String, String[]> requestParameterMap = new HashMap<String, String[]>();
        requestParameterMap.put("someName", new String[]{"someValue"});
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("https://www.example.biz?hello=world#fragment");
        request.addParameters(requestParameterMap);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        request.setRequestURI("https://www.example.org?hello=world#fragment");
        request.addParameters(requestParameterMap);
        Assertions.assertThrows(RuntimeException.class, () -> filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain));
    }
}

