/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view;

import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.MockWebServer;
import org.apereo.cas.web.view.RestfulUrlTemplateResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.templateresolver.TemplateResolution;

@Tag(value="RestfulApi")
public class RestfulUrlTemplateResolverTests {
    @Test
    public void verifyAction() {
        try (MockWebServer webServer = new MockWebServer(9302, (Resource)new ByteArrayResource("template".getBytes(StandardCharsets.UTF_8), "REST Output"), "application/json");){
            webServer.start();
            CasConfigurationProperties props = new CasConfigurationProperties();
            props.getView().getRest().setUrl("http://localhost:9302");
            RestfulUrlTemplateResolver r = new RestfulUrlTemplateResolver(props);
            TemplateResolution res = r.resolveTemplate((IEngineConfiguration)Mockito.mock(IEngineConfiguration.class), "cas", "template", new LinkedHashMap());
            Assertions.assertNotNull((Object)res);
        }
        catch (Exception e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }
}

