/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support.filters;

import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.web.support.filters.AbstractSecurityFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddResponseHeadersFilter
extends AbstractSecurityFilter
implements Filter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AddResponseHeadersFilter.class);
    private static final int MAP_SIZE = 8;
    private Map<String, String> headersMap = new LinkedHashMap<String, String>(8);

    public void init(FilterConfig filterConfig) {
        Enumeration initParamNames = filterConfig.getInitParameterNames();
        while (initParamNames.hasMoreElements()) {
            String paramName = (String)initParamNames.nextElement();
            String paramValue = filterConfig.getInitParameter(paramName);
            this.headersMap.put(paramName, paramValue);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletResponse instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            for (Map.Entry<String, String> entry : this.headersMap.entrySet()) {
                LOGGER.debug("Adding parameter [{}] with value [{}]", (Object)entry.getKey(), (Object)entry.getValue());
                httpServletResponse.addHeader(entry.getKey(), entry.getValue());
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    @Generated
    public void setHeadersMap(Map<String, String> headersMap) {
        this.headersMap = headersMap;
    }

    @Generated
    public Map<String, String> getHeadersMap() {
        return this.headersMap;
    }
}

