/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.configuration.model.core.web.LocaleProperties;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.support.RequestContextUtils;

public class CasLocaleChangeInterceptor
extends LocaleChangeInterceptor {
    private final LocaleProperties localeProperties;

    protected static void configureLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver((HttpServletRequest)request);
        if (localeResolver != null) {
            localeResolver.setLocale(request, response, locale);
            request.setAttribute(Locale.class.getName(), (Object)locale);
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException {
        return this.handleForcedLocale(request, response) || super.preHandle(request, response, handler);
    }

    protected boolean handleForcedLocale(HttpServletRequest request, HttpServletResponse response) {
        if (this.localeProperties.isForceDefaultLocale()) {
            Locale locale = new Locale(this.localeProperties.getDefaultValue());
            CasLocaleChangeInterceptor.configureLocale(request, response, locale);
        }
        return this.localeProperties.isForceDefaultLocale();
    }

    @Generated
    public CasLocaleChangeInterceptor(LocaleProperties localeProperties) {
        this.localeProperties = localeProperties;
    }
}

