/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.web.flow.actions.AbstractAuthenticationAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageResolver;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractNonInteractiveCredentialsAction
extends AbstractAuthenticationAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNonInteractiveCredentialsAction.class);
    private static final String BAD_X509_CREDENTIALS_MSG_CODE = "error.x509.credentials.bad";

    public AbstractNonInteractiveCredentialsAction(CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy) {
        super(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy);
    }

    protected Event doPreExecute(RequestContext context) throws Exception {
        Credential credential = this.constructCredentialsFromRequest(context);
        if (credential == null) {
            LOGGER.warn("No credentials detected. Navigating to error...");
            return this.error();
        }
        WebUtils.putCredential((RequestContext)context, (Credential)credential);
        return super.doPreExecute(context);
    }

    @Override
    protected void onError(RequestContext requestContext) {
        MessageResolver resolver = new MessageBuilder().error().code(BAD_X509_CREDENTIALS_MSG_CODE).defaultText(BAD_X509_CREDENTIALS_MSG_CODE).build();
        requestContext.getMessageContext().addMessage(resolver);
    }

    protected abstract Credential constructCredentialsFromRequest(RequestContext var1);
}

