/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.decorator;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import org.apereo.cas.category.RestfulApiCategory;
import org.apereo.cas.configuration.model.webapp.WebflowLoginDecoratorProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.MockWebServer;
import org.apereo.cas.web.flow.decorator.RestfulLoginWebflowDecorator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@Category(value={RestfulApiCategory.class})
public class RestfulLoginWebflowDecoratorTests {
    @Test
    public void verifyOperation() {
        WebflowLoginDecoratorProperties.Rest props = new WebflowLoginDecoratorProperties.Rest();
        props.setUrl("http://localhost:9465");
        RestfulLoginWebflowDecorator rest = new RestfulLoginWebflowDecorator(props);
        MockRequestContext requestContext = new MockRequestContext();
        try (MockWebServer webServer = new MockWebServer(9465, (Resource)new ByteArrayResource(RestfulLoginWebflowDecoratorTests.getJsonData().getBytes(StandardCharsets.UTF_8), "REST Output"), "application/json");){
            webServer.start();
            rest.decorate((RequestContext)requestContext, (ApplicationContext)Mockito.mock(ApplicationContext.class));
            Assert.assertTrue((boolean)requestContext.getFlowScope().contains("decoration"));
        }
        catch (Exception e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    private static String getJsonData() {
        return new ObjectMapper().writeValueAsString((Object)CollectionUtils.wrap((String)"key", (Object)"value"));
    }
}

