/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.configurer;

import java.util.Collection;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class CompositeProviderSelectionMultifactorWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public static final String MFA_COMPOSITE_EVENT_ID = "mfa-composite";
    static final String ACTION_ID_PREPARE_MULTIFACTOR_PROVIDER_SELECTION = "prepareMultifactorProviderSelectionAction";
    static final String ACTION_ID_MULTIFACTOR_PROVIDER_SELECTED = "multifactorProviderSelectedAction";

    public CompositeProviderSelectionMultifactorWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            TransitionableState realSubmit = this.getState(flow, "realSubmit");
            this.createTransitionForState(realSubmit, MFA_COMPOSITE_EVENT_ID, MFA_COMPOSITE_EVENT_ID);
            ViewState viewState = this.createViewState(flow, MFA_COMPOSITE_EVENT_ID, "casCompositeMfaProviderSelectionView");
            viewState.getEntryActionList().add((Action)this.createEvaluateAction(ACTION_ID_PREPARE_MULTIFACTOR_PROVIDER_SELECTION));
            this.createTransitionForState((TransitionableState)viewState, "submit", "compositeMfaProviderSelectedAction");
            ActionState selectedState = this.createActionState(flow, "compositeMfaProviderSelectedAction", (Action)this.createEvaluateAction(ACTION_ID_MULTIFACTOR_PROVIDER_SELECTED));
            Collection providers = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext).values();
            providers.forEach(p -> this.createTransitionForState((TransitionableState)selectedState, p.getId(), p.getId()));
        }
    }
}

