/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidator;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.AbstractCasMultifactorAuthenticationWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class RankedMultifactorAuthenticationProviderWebflowEventResolver
extends AbstractCasMultifactorAuthenticationWebflowEventResolver
implements CasDelegatingWebflowEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RankedMultifactorAuthenticationProviderWebflowEventResolver.class);
    private final CasDelegatingWebflowEventResolver casDelegatingWebflowEventResolver;
    private final MultifactorAuthenticationContextValidator authenticationContextValidator;
    private final SingleSignOnParticipationStrategy renewalStrategy;

    public RankedMultifactorAuthenticationProviderWebflowEventResolver(CasWebflowEventResolutionConfigurationContext webflowEventResolutionConfigurationContext, CasDelegatingWebflowEventResolver casDelegatingWebflowEventResolver, MultifactorAuthenticationContextValidator authenticationContextValidator, SingleSignOnParticipationStrategy renewalStrategy) {
        super(webflowEventResolutionConfigurationContext);
        this.casDelegatingWebflowEventResolver = casDelegatingWebflowEventResolver;
        this.authenticationContextValidator = authenticationContextValidator;
        this.renewalStrategy = renewalStrategy;
    }

    public Set<Event> resolveInternal(RequestContext context) {
        String tgt = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        RegisteredService service = WebUtils.getRegisteredService((RequestContext)context);
        if (service == null) {
            LOGGER.debug("No service is available to determine event for principal");
            return this.resumeFlow();
        }
        if (StringUtils.isBlank((CharSequence)tgt)) {
            LOGGER.trace("Ticket-granting ticket is blank; proceed with flow normally.");
            return this.resumeFlow();
        }
        Authentication authentication = this.getWebflowEventResolutionConfigurationContext().getTicketRegistrySupport().getAuthenticationFrom(tgt);
        if (authentication == null) {
            LOGGER.trace("Ticket-granting ticket has no authentication and is blank; proceed with flow normally.");
            return this.resumeFlow();
        }
        Credential credential = WebUtils.getCredential((RequestContext)context);
        AuthenticationResultBuilder builder = this.getWebflowEventResolutionConfigurationContext().getAuthenticationSystemSupport().establishAuthenticationContextFromInitial(authentication, credential);
        LOGGER.trace("Recording and tracking initial authentication results in the request context");
        WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)builder, (RequestContext)context);
        WebUtils.putAuthentication((Authentication)authentication, (RequestContext)context);
        if (this.renewalStrategy.supports(context) && !this.renewalStrategy.isParticipating(context)) {
            LOGGER.debug("Cannot proceed with existing authenticated session for [{}] since the single sign-on participation strategy for this request could now allow participation in the current session.", (Object)authentication);
            return this.resumeFlow();
        }
        Event event = this.casDelegatingWebflowEventResolver.resolveSingle(context);
        if (event == null) {
            LOGGER.trace("Request does not indicate a requirement for authentication policy; proceed with flow normally.");
            return this.resumeFlow();
        }
        String id = event.getId();
        LOGGER.trace("Resolved event from the initial authentication leg is [{}]", (Object)id);
        if (List.of("error", "authenticationFailure", "success", "successWithWarnings").contains(id)) {
            LOGGER.trace("Returning webflow event as [{}]", (Object)id);
            return CollectionUtils.wrapSet((Object)event);
        }
        LOGGER.trace("Validating authentication context for event [{}] and service [{}]", (Object)id, (Object)service);
        Pair result = this.authenticationContextValidator.validate(authentication, id, service);
        Optional value = (Optional)result.getValue();
        if (((Boolean)result.getKey()).booleanValue()) {
            if (service.getMultifactorPolicy().isForceExecution() && value.isPresent()) {
                MultifactorAuthenticationProvider provider = (MultifactorAuthenticationProvider)value.get();
                LOGGER.trace("Multifactor authentication policy for [{}] is set to force execution for [{}]", (Object)service, (Object)provider);
                return RankedMultifactorAuthenticationProviderWebflowEventResolver.buildEventForMultifactorProvider(context, service, authentication, id, provider);
            }
            LOGGER.debug("Authentication context is successfully validated by [{}] for service [{}]", (Object)id, (Object)service);
            return this.resumeFlow();
        }
        if (value.isPresent()) {
            MultifactorAuthenticationProvider provider = (MultifactorAuthenticationProvider)value.get();
            return RankedMultifactorAuthenticationProviderWebflowEventResolver.buildEventForMultifactorProvider(context, service, authentication, id, provider);
        }
        LOGGER.warn("The authentication context cannot be satisfied and the requested event [{}] is unrecognized", (Object)id);
        return CollectionUtils.wrapSet((Object)new Event((Object)this, "error"));
    }

    @Audit(action="AUTHENTICATION_EVENT", actionResolverName="AUTHENTICATION_EVENT_ACTION_RESOLVER", resourceResolverName="AUTHENTICATION_EVENT_RESOURCE_RESOLVER")
    public Event resolveSingle(RequestContext context) {
        return super.resolveSingle(context);
    }

    public void addDelegate(CasWebflowEventResolver r) {
        this.casDelegatingWebflowEventResolver.addDelegate(r);
    }

    public void addDelegate(CasWebflowEventResolver r, int index) {
        this.casDelegatingWebflowEventResolver.addDelegate(r, index);
    }

    private Set<Event> resumeFlow() {
        return CollectionUtils.wrapSet((Object)new EventFactorySupport().success((Object)this));
    }

    private static Set<Event> buildEventForMultifactorProvider(RequestContext context, RegisteredService service, Authentication authentication, String id, MultifactorAuthenticationProvider provider) {
        Map attributeMap = MultifactorAuthenticationUtils.buildEventAttributeMap((Principal)authentication.getPrincipal(), Optional.of(service), (MultifactorAuthenticationProvider)provider);
        LOGGER.trace("Event attribute map for [{}] is [{}]", (Object)id, (Object)attributeMap);
        Event resultEvent = MultifactorAuthenticationUtils.validateEventIdForMatchingTransitionInContext((String)id, Optional.of(context), (Map)attributeMap);
        LOGGER.trace("Finalized event for multifactor provider  [{}] is [{}]", (Object)id, (Object)resultEvent);
        return CollectionUtils.wrapSet((Object)resultEvent);
    }
}

