/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class MultifactorAuthenticationBypassAction
extends AbstractMultifactorAuthenticationAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationBypassAction.class);

    public MultifactorAuthenticationBypassAction(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    protected Event doExecute(RequestContext requestContext) {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        RegisteredService service = WebUtils.getRegisteredService((RequestContext)requestContext);
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext();
        MultifactorAuthenticationProviderBypassEvaluator bypass = this.provider.getBypassEvaluator();
        Principal principal = authentication.getPrincipal();
        if (requestContext.getCurrentTransition().getId().equals("bypass")) {
            LOGGER.debug("Bypass triggered by MFA webflow for MFA for user [{}] for provider [{}]", (Object)principal.getId(), (Object)this.provider.getId());
            bypass.rememberBypass(authentication, this.provider);
            LOGGER.debug("Authentication updated to remember bypass for user [{}] for provider [{}]", (Object)principal.getId(), (Object)this.provider.getId());
            return this.yes();
        }
        if (bypass.shouldMultifactorAuthenticationProviderExecute(authentication, service, this.provider, request)) {
            LOGGER.debug("Bypass rules determined MFA should execute for user [{}] and provider [{}]", (Object)principal.getId(), (Object)this.provider.getId());
            bypass.forgetBypass(authentication);
            LOGGER.debug("Authentication updated to forget any existing bypass for user [{}] for provider [{}]", (Object)principal.getId(), (Object)this.provider.getId());
            return this.no();
        }
        LOGGER.debug("Bypass rules determined MFA should NOT execute for user [{}] for provider [{}]", (Object)principal.getId(), (Object)this.provider.getId());
        bypass.rememberBypass(authentication, this.provider);
        LOGGER.debug("Authentication updated to remember bypass for user [{}] for provider [{}]", (Object)principal.getId(), (Object)this.provider.getId());
        return this.yes();
    }
}

