/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl.mfa;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.authentication.BaseMultifactorAuthenticationProviderEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DefaultMultifactorAuthenticationProviderWebflowEventResolver
extends BaseMultifactorAuthenticationProviderEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMultifactorAuthenticationProviderWebflowEventResolver.class);
    private final MultifactorAuthenticationTrigger multifactorAuthenticationTrigger;

    public DefaultMultifactorAuthenticationProviderWebflowEventResolver(CasWebflowEventResolutionConfigurationContext webflowEventResolutionConfigurationContext, MultifactorAuthenticationTrigger multifactorAuthenticationTrigger) {
        super(webflowEventResolutionConfigurationContext);
        this.multifactorAuthenticationTrigger = multifactorAuthenticationTrigger;
    }

    public Set<Event> resolveInternal(RequestContext context) {
        RegisteredService registeredService = this.resolveRegisteredServiceInRequestContext(context);
        Service service = this.resolveServiceFromAuthenticationRequest(context);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        Optional result = this.multifactorAuthenticationTrigger.isActivated(authentication, registeredService, request, service);
        return result.map(provider -> {
            LOGGER.trace("Building event based on the authentication provider [{}] and service [{}]", provider, (Object)registeredService);
            Map eventMap = MultifactorAuthenticationUtils.buildEventAttributeMap((Principal)authentication.getPrincipal(), Optional.ofNullable(registeredService), (MultifactorAuthenticationProvider)provider);
            eventMap.put(MultifactorAuthenticationTrigger.class.getSimpleName(), this.multifactorAuthenticationTrigger.getName());
            Event event = MultifactorAuthenticationUtils.validateEventIdForMatchingTransitionInContext((String)provider.getId(), Optional.of(context), (Map)eventMap);
            return CollectionUtils.wrapSet((Object)event);
        }).orElse(null);
    }

    @Audit(action="AUTHENTICATION_EVENT", actionResolverName="AUTHENTICATION_EVENT_ACTION_RESOLVER", resourceResolverName="AUTHENTICATION_EVENT_RESOURCE_RESOLVER")
    public Event resolveSingle(RequestContext context) {
        return super.resolveSingle(context);
    }
}

