/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions.composite;

import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.ChainingMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PrepareMultifactorProviderSelectionAction
extends AbstractAction {
    protected Event doExecute(RequestContext requestContext) {
        AttributeMap attributes = requestContext.getCurrentEvent().getAttributes();
        RegisteredService registeredService = (RegisteredService)attributes.get(RegisteredService.class.getName());
        WebUtils.putRegisteredService((RequestContext)requestContext, (RegisteredService)registeredService);
        ChainingMultifactorAuthenticationProvider mfaProvider = (ChainingMultifactorAuthenticationProvider)attributes.get(MultifactorAuthenticationProvider.class.getName());
        Authentication authn = WebUtils.getAuthentication((RequestContext)requestContext);
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        List mfaProviders = mfaProvider.getMultifactorAuthenticationProviders().stream().filter(p -> p.isAvailable(registeredService) && p.getBypassEvaluator().shouldMultifactorAuthenticationProviderExecute(authn, registeredService, p, request)).map(MultifactorAuthenticationProvider::getId).collect(Collectors.toList());
        WebUtils.putSelectableMultifactorAuthenticationProviders((RequestContext)requestContext, mfaProviders);
        return null;
    }
}

