/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.acct.webflow;

import org.apereo.cas.acct.AccountRegistrationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.account.AccountManagementRegistrationProperties;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;

public class AccountManagementWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public static final String FLOW_ID_ACCOUNT_REGISTRATION = "acctreg";

    public AccountManagementWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        ConsumerExecutionAction startAction = new ConsumerExecutionAction(context -> AccountRegistrationUtils.putAccountRegistrationEnabled(context, true));
        flow.getStartActionList().add((Action)startAction);
        ViewState signUpView = this.createViewState(flow, "viewAccountSignUp", "acct-mgmt/casAccountSignupView");
        this.createTransitionForState((TransitionableState)signUpView, "submit", "submitAccountRegistration");
        signUpView.getEntryActionList().add((Action)this.createEvaluateAction("loadAccountRegistrationPropertiesAction"));
        TransitionableState viewLoginForm = this.getState(flow, "viewLoginForm");
        this.createTransitionForState(viewLoginForm, "signup", signUpView.getId());
        ActionState submitAccountRegistration = this.createActionState(flow, "submitAccountRegistration", new String[]{"submitAccountRegistrationAction"});
        this.createTransitionForState((TransitionableState)submitAccountRegistration, "error", signUpView.getId());
        this.createTransitionForState((TransitionableState)submitAccountRegistration, "success", "accountSignUpInfoSent");
        this.createEndState(flow, "accountSignUpInfoSent", "acct-mgmt/casAccountSignupViewSentInfo");
        this.registerAccountRegistrationFlowDefinition();
    }

    private void registerAccountRegistrationFlowDefinition() {
        AccountManagementRegistrationProperties properties = this.casProperties.getAccountRegistration();
        Flow acctRegFlow = this.buildFlow(FLOW_ID_ACCOUNT_REGISTRATION);
        this.createEndState(acctRegFlow, "accountRegistrationCompleted");
        acctRegFlow.getStartActionList().add((Action)this.createEvaluateAction("initialFlowSetupAction"));
        ViewState completeView = this.createViewState(acctRegFlow, "completeAccountRegistrationView", "acct-mgmt/casAccountSignupViewComplete");
        completeView.getEntryActionList().add((Action)new ConsumerExecutionAction(context -> {
            WebUtils.putPasswordPolicyPattern((RequestContext)context, (String)properties.getCore().getPasswordPolicyPattern());
            AccountRegistrationUtils.putAccountRegistrationSecurityQuestionsCount(context, properties.getCore().getSecurityQuestionsCount());
        }));
        this.createTransitionForState((TransitionableState)completeView, "submit", "finalizeRegistrationRequest");
        ActionState finalize = this.createActionState(acctRegFlow, "finalizeRegistrationRequest", new String[]{"finalizeAccountRegistrationRequestAction"});
        this.createTransitionForState((TransitionableState)finalize, "success", "accountRegistrationCompletedView");
        this.createTransitionForState((TransitionableState)finalize, "error", "completeAccountRegistrationView");
        ViewState completedView = this.createViewState(acctRegFlow, "accountRegistrationCompletedView", "acct-mgmt/casAccountSignupViewCompleted");
        this.createStateDefaultTransition((TransitionableState)completedView, "accountRegistrationCompleted");
        acctRegFlow.setStartState((State)completeView);
        this.mainFlowDefinitionRegistry.registerFlowDefinition((FlowDefinition)acctRegFlow);
        Flow flow = this.getLoginFlow();
        this.createSubflowState(flow, "accountRegistrationSubflow", FLOW_ID_ACCOUNT_REGISTRATION);
        ActionState initializeLoginFormState = (ActionState)this.getState(flow, "initializeLoginForm", ActionState.class);
        String originalTargetState = initializeLoginFormState.getTransition("success").getTargetStateId();
        this.createTransitionForState((TransitionableState)initializeLoginFormState, "success", "checkForAccountRegistrationToken", true);
        this.createDecisionState(flow, "checkForAccountRegistrationToken", "requestParameters.acctregtoken != null", "validateAccountRegistrationToken", originalTargetState);
        ActionState validateState = this.createActionState(flow, "validateAccountRegistrationToken", new String[]{"validateAccountRegistrationTokenAction"});
        this.createTransitionForState((TransitionableState)validateState, "success", "accountRegistrationSubflow");
        this.createTransitionForState((TransitionableState)validateState, "error", "serviceUnauthorizedCheck");
    }
}

