/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.acct.webflow;

import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.acct.AccountRegistrationRequest;
import org.apereo.cas.acct.AccountRegistrationResponse;
import org.apereo.cas.acct.AccountRegistrationService;
import org.apereo.cas.acct.AccountRegistrationUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class FinalizeAccountRegistrationAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FinalizeAccountRegistrationAction.class);
    private final AccountRegistrationService accountRegistrationService;

    protected Event doExecuteInternal(RequestContext requestContext) {
        try {
            AccountRegistrationRequest registrationRequest = AccountRegistrationUtils.getAccountRegistrationRequest(requestContext);
            Objects.requireNonNull(registrationRequest).putProperties(requestContext.getRequestParameters().asAttributeMap().asMap());
            AccountRegistrationResponse response = this.accountRegistrationService.getAccountRegistrationProvisioner().provision(registrationRequest);
            if (response.isSuccess()) {
                return this.success(response);
            }
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)"cas.screen.acct.error.provision");
        return this.error();
    }

    @Generated
    public FinalizeAccountRegistrationAction(AccountRegistrationService accountRegistrationService) {
        this.accountRegistrationService = accountRegistrationService;
    }
}

