/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.acct.webflow;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.acct.AccountRegistrationRequest;
import org.apereo.cas.acct.AccountRegistrationService;
import org.apereo.cas.acct.AccountRegistrationUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.mail.EmailCommunicationResult;
import org.apereo.cas.notifications.mail.EmailMessageBodyBuilder;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.notifications.sms.SmsBodyBuilder;
import org.apereo.cas.notifications.sms.SmsRequest;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SubmitAccountRegistrationAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SubmitAccountRegistrationAction.class);
    private final AccountRegistrationService accountRegistrationService;
    private final CasConfigurationProperties casProperties;
    private final CommunicationsManager communicationsManager;
    private final TicketFactory ticketFactory;
    private final TicketRegistry ticketRegistry;

    protected Event doExecuteInternal(RequestContext requestContext) {
        try {
            Collection properties = this.accountRegistrationService.getAccountRegistrationPropertyLoader().load().values();
            AccountRegistrationRequest registrationRequest = new AccountRegistrationRequest();
            properties.forEach(entry -> {
                String value = entry.isRequired() ? requestContext.getRequestParameters().getRequired(entry.getName()) : requestContext.getRequestParameters().get(entry.getName());
                registrationRequest.putProperty(entry.getName(), (Object)value);
            });
            String username = this.accountRegistrationService.getAccountRegistrationUsernameBuilder().build(registrationRequest);
            AccountRegistrationUtils.putAccountRegistrationRequest(requestContext, registrationRequest);
            AccountRegistrationUtils.putAccountRegistrationRequestUsername(requestContext, username);
            String url = this.createAccountRegistrationActivationUrl(registrationRequest);
            EmailCommunicationResult sendEmail = this.sendAccountRegistrationActivationEmail(registrationRequest, url, requestContext);
            boolean sendSms = this.sendAccountRegistrationActivationSms(registrationRequest, url);
            if (sendEmail.isSuccess() || sendSms) {
                return this.success(url);
            }
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)"cas.screen.acct.error.fail");
        return this.error();
    }

    protected boolean sendAccountRegistrationActivationSms(AccountRegistrationRequest registrationRequest, String url) throws Throwable {
        if (StringUtils.isNotBlank((CharSequence)registrationRequest.getPhone())) {
            SmsProperties smsProps = this.casProperties.getAccountRegistration().getSms();
            String message = SmsBodyBuilder.builder().properties(smsProps).parameters(Map.of("url", url)).build().get();
            SmsRequest smsRequest = SmsRequest.builder().from(smsProps.getFrom()).to(registrationRequest.getPhone()).text(message).build();
            return this.communicationsManager.sms(smsRequest);
        }
        return false;
    }

    protected EmailCommunicationResult sendAccountRegistrationActivationEmail(AccountRegistrationRequest registrationRequest, String url, RequestContext requestContext) {
        if (StringUtils.isNotBlank((CharSequence)registrationRequest.getEmail())) {
            EmailProperties emailProps = this.casProperties.getAccountRegistration().getMail();
            Map parameters = CollectionUtils.wrap((String)"url", (Object)url);
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            Optional<Locale> locale = Optional.ofNullable(RequestContextUtils.getLocaleResolver((HttpServletRequest)request)).map(resolver -> resolver.resolveLocale(request));
            String text = EmailMessageBodyBuilder.builder().properties(emailProps).parameters(parameters).locale(locale).build().get();
            EmailMessageRequest emailRequest = EmailMessageRequest.builder().emailProperties(emailProps).locale(locale.orElseGet(Locale::getDefault)).to(List.of(registrationRequest.getEmail())).body(text).build();
            return this.communicationsManager.email(emailRequest);
        }
        return EmailCommunicationResult.builder().success(false).build();
    }

    protected String createAccountRegistrationActivationUrl(AccountRegistrationRequest registrationRequest) throws Throwable {
        String token = this.accountRegistrationService.createToken(registrationRequest);
        TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
        Map properties = CollectionUtils.wrap((String)"acctregtoken", (Object)token);
        TransientSessionTicket ticket = transientFactory.create((Service)null, properties);
        this.ticketRegistry.addTicket((Ticket)ticket);
        return new URIBuilder(this.casProperties.getServer().getLoginUrl()).addParameter("acctregtoken", ticket.getId()).build().toURL().toExternalForm();
    }

    @Generated
    public SubmitAccountRegistrationAction(AccountRegistrationService accountRegistrationService, CasConfigurationProperties casProperties, CommunicationsManager communicationsManager, TicketFactory ticketFactory, TicketRegistry ticketRegistry) {
        this.accountRegistrationService = accountRegistrationService;
        this.casProperties = casProperties;
        this.communicationsManager = communicationsManager;
        this.ticketFactory = ticketFactory;
        this.ticketRegistry = ticketRegistry;
    }
}

