/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.acct.webflow;

import lombok.Generated;
import org.apereo.cas.acct.AccountRegistrationRequest;
import org.apereo.cas.acct.AccountRegistrationService;
import org.apereo.cas.acct.AccountRegistrationUtils;
import org.apereo.cas.authentication.RootCasException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ValidateAccountRegistrationTokenAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateAccountRegistrationTokenAction.class);
    private final TicketRegistry ticketRegistry;
    private final AccountRegistrationService accountRegistrationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Event doExecuteInternal(RequestContext requestContext) throws Exception {
        TransientSessionTicket accountRegTicket = null;
        try {
            String activationToken = requestContext.getRequestParameters().getRequired("acctregtoken");
            accountRegTicket = (TransientSessionTicket)this.ticketRegistry.getTicket(activationToken, TransientSessionTicket.class);
            String token = (String)accountRegTicket.getProperty("acctregtoken", String.class);
            AccountRegistrationRequest registrationRequest = this.accountRegistrationService.validateToken(token);
            accountRegTicket.update();
            String username = this.accountRegistrationService.getAccountRegistrationUsernameBuilder().build(registrationRequest);
            AccountRegistrationUtils.putAccountRegistrationRequest(requestContext, registrationRequest);
            AccountRegistrationUtils.putAccountRegistrationRequestUsername(requestContext, username);
            Event event = this.success(registrationRequest);
            return event;
        }
        catch (Exception e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
            requestContext.getFlashScope().put("rootCauseException", (Object)RootCasException.withCode((String)"screen.error.page.invalidrequest.desc"));
            Event event = this.error(e);
            return event;
        }
        finally {
            if (accountRegTicket != null && accountRegTicket.isExpired()) {
                this.ticketRegistry.deleteTicket((Ticket)accountRegTicket);
            }
        }
    }

    @Generated
    public ValidateAccountRegistrationTokenAction(TicketRegistry ticketRegistry, AccountRegistrationService accountRegistrationService) {
        this.ticketRegistry = ticketRegistry;
        this.accountRegistrationService = accountRegistrationService;
    }
}

