/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.stream.Collectors;
import org.apereo.cas.acct.AccountRegistrationPropertyLoader;
import org.apereo.cas.acct.AccountRegistrationRequestAuditPrincipalIdResolver;
import org.apereo.cas.acct.AccountRegistrationService;
import org.apereo.cas.acct.AccountRegistrationTokenCipherExecutor;
import org.apereo.cas.acct.AccountRegistrationUsernameBuilder;
import org.apereo.cas.acct.AccountRegistrationUtils;
import org.apereo.cas.acct.DefaultAccountRegistrationPropertyLoader;
import org.apereo.cas.acct.DefaultAccountRegistrationService;
import org.apereo.cas.acct.provision.AccountRegistrationProvisioner;
import org.apereo.cas.acct.provision.AccountRegistrationProvisionerConfigurer;
import org.apereo.cas.acct.provision.ChainingAccountRegistrationProvisioner;
import org.apereo.cas.acct.provision.GroovyAccountRegistrationProvisioner;
import org.apereo.cas.acct.provision.RestfulAccountRegistrationProvisioner;
import org.apereo.cas.acct.provision.ScimAccountRegistrationProvisioner;
import org.apereo.cas.acct.webflow.AccountManagementRegistrationCaptchaWebflowConfigurer;
import org.apereo.cas.acct.webflow.AccountManagementWebflowConfigurer;
import org.apereo.cas.acct.webflow.FinalizeAccountRegistrationAction;
import org.apereo.cas.acct.webflow.LoadAccountRegistrationPropertiesAction;
import org.apereo.cas.acct.webflow.SubmitAccountRegistrationAction;
import org.apereo.cas.acct.webflow.ValidateAccountRegistrationTokenAction;
import org.apereo.cas.audit.AuditPrincipalIdProvider;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalProvisioner;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.account.provision.GroovyAccountManagementRegistrationProvisioningProperties;
import org.apereo.cas.configuration.model.support.account.provision.RestfulAccountManagementRegistrationProvisioningProperties;
import org.apereo.cas.configuration.model.support.captcha.GoogleRecaptchaProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.scim.v2.ScimV2PrincipalAttributeMapper;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.scripting.WatchableGroovyScriptResource;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnMissingGraalVMNativeImage;
import org.apereo.cas.web.CaptchaActivationStrategy;
import org.apereo.cas.web.CaptchaValidator;
import org.apereo.cas.web.DefaultCaptchaActivationStrategy;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.InitializeCaptchaAction;
import org.apereo.cas.web.flow.ValidateCaptchaAction;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.AccountRegistration})
@AutoConfiguration
public class CasAccountManagementWebflowConfiguration {
    @ConditionalOnMissingBean(name={"accountMgmtCipherExecutor"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public CipherExecutor accountMgmtCipherExecutor(CasConfigurationProperties casProperties) {
        EncryptionJwtSigningJwtCryptographyProperties crypto = casProperties.getAccountRegistration().getCore().getCrypto();
        return crypto.isEnabled() ? CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, AccountRegistrationTokenCipherExecutor.class) : CipherExecutor.noOp();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"accountRegistrationUsernameBuilder"})
    public AccountRegistrationUsernameBuilder accountRegistrationUsernameBuilder() {
        return AccountRegistrationUsernameBuilder.asDefault();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"accountMgmtRegistrationService"})
    public AccountRegistrationService accountMgmtRegistrationService(CasConfigurationProperties casProperties, @Qualifier(value="accountMgmtRegistrationPropertyLoader") AccountRegistrationPropertyLoader accountMgmtRegistrationPropertyLoader, @Qualifier(value="accountMgmtCipherExecutor") CipherExecutor accountMgmtCipherExecutor, @Qualifier(value="accountRegistrationUsernameBuilder") AccountRegistrationUsernameBuilder accountRegistrationUsernameBuilder, @Qualifier(value="accountMgmtRegistrationProvisioner") AccountRegistrationProvisioner accountMgmtRegistrationProvisioner) {
        return new DefaultAccountRegistrationService(accountMgmtRegistrationPropertyLoader, casProperties, accountMgmtCipherExecutor, accountRegistrationUsernameBuilder, accountMgmtRegistrationProvisioner);
    }

    @Bean
    @ConditionalOnMissingBean(name={"accountMgmtRegistrationPropertyLoader"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AccountRegistrationPropertyLoader accountMgmtRegistrationPropertyLoader(CasConfigurationProperties casProperties) {
        Resource resource = casProperties.getAccountRegistration().getCore().getRegistrationProperties().getLocation();
        return new DefaultAccountRegistrationPropertyLoader(resource);
    }

    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.AccountRegistration}, module="captcha")
    @Configuration(value="CasAccountManagementRegistrationCaptchaConfiguration", proxyBeanMethods=false)
    public static class CasAccountManagementRegistrationCaptchaConfiguration {
        private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.account-registration.google-recaptcha.enabled").isTrue();

        @ConditionalOnMissingBean(name={"accountMgmtRegistrationCaptchaWebflowConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public CasWebflowConfigurer accountMgmtRegistrationCaptchaWebflowConfigurer(@Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                AccountManagementRegistrationCaptchaWebflowConfigurer configurer = new AccountManagementRegistrationCaptchaWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
                configurer.setOrder(casProperties.getAccountRegistration().getWebflow().getOrder() + 2);
                return configurer;
            }).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"accountMgmtRegistrationValidateCaptchaAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public Action accountMgmtRegistrationValidateCaptchaAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="accountMgmtRegistrationCaptchaActivationStrategy") CaptchaActivationStrategy accountMgmtRegistrationCaptchaActivationStrategy) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> {
                GoogleRecaptchaProperties recaptcha = casProperties.getAccountRegistration().getGoogleRecaptcha();
                return new ValidateCaptchaAction(CaptchaValidator.getInstance((GoogleRecaptchaProperties)recaptcha), accountMgmtRegistrationCaptchaActivationStrategy);
            }).withId("accountMgmtRegistrationValidateCaptchaAction").build().get()).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"accountMgmtRegistrationCaptchaActivationStrategy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CaptchaActivationStrategy accountMgmtRegistrationCaptchaActivationStrategy(ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return (CaptchaActivationStrategy)BeanSupplier.of(CaptchaActivationStrategy.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DefaultCaptchaActivationStrategy(servicesManager)).otherwiseProxy().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"accountMgmtRegistrationInitializeCaptchaAction"})
        public Action accountMgmtRegistrationInitializeCaptchaAction(ConfigurableApplicationContext applicationContext, @Qualifier(value="accountMgmtRegistrationCaptchaActivationStrategy") CaptchaActivationStrategy accountMgmtRegistrationCaptchaActivationStrategy, CasConfigurationProperties casProperties) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                GoogleRecaptchaProperties recaptcha = casProperties.getAccountRegistration().getGoogleRecaptcha();
                return new InitializeCaptchaAction(accountMgmtRegistrationCaptchaActivationStrategy, requestContext -> AccountRegistrationUtils.putAccountRegistrationCaptchaEnabled(requestContext, recaptcha), recaptcha);
            }).otherwise(() -> ConsumerExecutionAction.NONE).get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountMgmtRegistrationCaptchaWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer accountMgmtRegistrationCaptchaWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="accountMgmtRegistrationCaptchaWebflowConfigurer") CasWebflowConfigurer cfg) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(cfg)).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasAccountManagementWebflowAuditConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasAccountManagementWebflowAuditConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountMgmtRegistrationAuditPrincipalIdResolver"})
        public AuditPrincipalIdProvider accountMgmtRegistrationAuditPrincipalIdResolver(@Qualifier(value="accountMgmtRegistrationService") AccountRegistrationService accountMgmtRegistrationService) {
            return new AccountRegistrationRequestAuditPrincipalIdResolver(accountMgmtRegistrationService);
        }

        @ConditionalOnMissingBean(name={"accountRegistrationAuditTrailRecordResolutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlanConfigurer accountRegistrationAuditTrailRecordResolutionPlanConfigurer(@Qualifier(value="returnValueResourceResolver") AuditResourceResolver returnValueResourceResolver) {
            return plan -> {
                plan.registerAuditActionResolver("ACCOUNT_REGISTRATION_TOKEN_VALIDATION_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_TOKEN_VALIDATED"));
                plan.registerAuditResourceResolver("ACCOUNT_REGISTRATION_TOKEN_VALIDATION_RESOURCE_RESOLVER", returnValueResourceResolver);
                plan.registerAuditActionResolver("ACCOUNT_REGISTRATION_TOKEN_CREATION_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_TOKEN_CREATED"));
                plan.registerAuditResourceResolver("ACCOUNT_REGISTRATION_TOKEN_CREATION_RESOURCE_RESOLVER", returnValueResourceResolver);
                plan.registerAuditActionResolver("ACCOUNT_REGISTRATION_PROVISIONING_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_PROVISIONING_SUCCESS"));
                plan.registerAuditResourceResolver("ACCOUNT_REGISTRATION_PROVISIONING_RESOURCE_RESOLVER", returnValueResourceResolver);
            };
        }
    }

    @Configuration(value="CasAccountManagementWebflowActionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasAccountManagementWebflowActionConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"validateAccountRegistrationTokenAction"})
        public Action validateAccountRegistrationTokenAction(ConfigurableApplicationContext applicationContext, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, CasConfigurationProperties casProperties, @Qualifier(value="accountMgmtRegistrationService") AccountRegistrationService accountMgmtRegistrationService) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new ValidateAccountRegistrationTokenAction(ticketRegistry, accountMgmtRegistrationService)).withId("validateAccountRegistrationTokenAction").build().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"finalizeAccountRegistrationRequestAction"})
        @Bean
        public Action finalizeAccountRegistrationRequestAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="accountMgmtRegistrationService") AccountRegistrationService accountMgmtRegistrationService) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new FinalizeAccountRegistrationAction(accountMgmtRegistrationService)).withId("finalizeAccountRegistrationRequestAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"loadAccountRegistrationPropertiesAction"})
        public Action loadAccountRegistrationPropertiesAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="accountMgmtRegistrationService") AccountRegistrationService accountMgmtRegistrationService) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new LoadAccountRegistrationPropertiesAction(accountMgmtRegistrationService)).withId("loadAccountRegistrationPropertiesAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"submitAccountRegistrationAction"})
        public Action submitAccountRegistrationAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="accountMgmtRegistrationService") AccountRegistrationService accountMgmtRegistrationService, @Qualifier(value="defaultTicketFactory") TicketFactory defaultTicketFactory, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="communicationsManager") CommunicationsManager communicationsManager) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new SubmitAccountRegistrationAction(accountMgmtRegistrationService, casProperties, communicationsManager, defaultTicketFactory, ticketRegistry)).withId("submitAccountRegistrationAction").build().get();
        }
    }

    @Configuration(value="CasAccountManagementWebflowPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasAccountManagementWebflowPlanConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountMgmtCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer accountMgmtCasWebflowExecutionPlanConfigurer(@Qualifier(value="accountMgmtWebflowConfigurer") CasWebflowConfigurer accountMgmtWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(accountMgmtWebflowConfigurer);
        }
    }

    @Configuration(value="CasAccountManagementWebflowCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasAccountManagementWebflowCoreConfiguration {
        @ConditionalOnMissingBean(name={"accountMgmtWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer accountMgmtWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return new AccountManagementWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        }
    }

    @ConditionalOnClass(value={ScimV2PrincipalAttributeMapper.class})
    @Configuration(value="CasAccountManagementScimProvisioningConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.AccountRegistration}, module="scim")
    public static class CasAccountManagementScimProvisioningConfiguration {
        @ConditionalOnMissingBean(name={"scimAccountRegistrationProvisionerConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AccountRegistrationProvisionerConfigurer scimAccountRegistrationProvisionerConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="principalProvisioner") ObjectProvider<PrincipalProvisioner> principalProvisioners) {
            return (AccountRegistrationProvisionerConfigurer)BeanSupplier.of(AccountRegistrationProvisionerConfigurer.class).when(BeanCondition.on((String)"cas.account-registration.provisioning.scim.enabled").isTrue().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> () -> new ScimAccountRegistrationProvisioner((PrincipalProvisioner)principalProvisioners.getObject(), PrincipalFactoryUtils.newPrincipalFactory())).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasAccountManagementProvisioningConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasAccountManagementProvisioningConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountMgmtRegistrationProvisioner"})
        public AccountRegistrationProvisioner accountMgmtRegistrationProvisioner(List<AccountRegistrationProvisionerConfigurer> beans) {
            List configurers = beans.stream().filter(BeanSupplier::isNotProxy).map(AccountRegistrationProvisionerConfigurer::configure).sorted().collect(Collectors.toList());
            return new ChainingAccountRegistrationProvisioner(configurers);
        }

        @ConditionalOnMissingBean(name={"restfulAccountRegistrationProvisionerConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AccountRegistrationProvisionerConfigurer restfulAccountRegistrationProvisionerConfigurer(@Qualifier(value="httpClient") HttpClient httpClient, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (AccountRegistrationProvisionerConfigurer)BeanSupplier.of(AccountRegistrationProvisionerConfigurer.class).when(BeanCondition.on((String)"cas.account-registration.provisioning.rest.url").isUrl().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> () -> {
                RestfulAccountManagementRegistrationProvisioningProperties props = casProperties.getAccountRegistration().getProvisioning().getRest();
                return new RestfulAccountRegistrationProvisioner(httpClient, props);
            }).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"groovyAccountRegistrationProvisionerConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingGraalVMNativeImage
        public AccountRegistrationProvisionerConfigurer groovyAccountRegistrationProvisionerConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return (AccountRegistrationProvisionerConfigurer)BeanSupplier.of(AccountRegistrationProvisionerConfigurer.class).when(BeanCondition.on((String)"cas.account-registration.provisioning.groovy.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> () -> {
                GroovyAccountManagementRegistrationProvisioningProperties groovy = casProperties.getAccountRegistration().getProvisioning().getGroovy();
                return new GroovyAccountRegistrationProvisioner(new WatchableGroovyScriptResource(groovy.getLocation()), (ApplicationContext)applicationContext);
            }).otherwiseProxy().get();
        }
    }
}

