/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.audit.AuditTrailExecutionPlanConfigurer;
import org.apereo.cas.audit.CouchDbAuditTrailManager;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.couchdb.BaseCouchDbProperties;
import org.apereo.cas.couchdb.audit.AuditActionContextCouchDbRepository;
import org.apereo.cas.couchdb.core.CouchDbConnectorFactory;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.ektorp.impl.ObjectMapperFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casSupportCouchDbAuditConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasSupportCouchDbAuditConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="defaultObjectMapperFactory")
    private ObjectProvider<ObjectMapperFactory> defaultObjectMapperFactory;

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"auditCouchDbFactory"})
    public CouchDbConnectorFactory auditCouchDbFactory() {
        return new CouchDbConnectorFactory((BaseCouchDbProperties)this.casProperties.getAudit().getCouchDb(), (ObjectMapperFactory)this.defaultObjectMapperFactory.getObject());
    }

    @ConditionalOnMissingBean(name={"auditActionContextCouchDbRepository"})
    @Bean
    @RefreshScope
    public AuditActionContextCouchDbRepository auditActionContextCouchDbRepository(@Qualifier(value="auditCouchDbFactory") CouchDbConnectorFactory auditCouchDbFactory) {
        return new AuditActionContextCouchDbRepository(auditCouchDbFactory.getCouchDbConnector(), this.casProperties.getAudit().getCouchDb().isCreateIfNotExists());
    }

    @ConditionalOnMissingBean(name={"couchDbAuditTrailManager"})
    @Bean
    @RefreshScope
    public AuditTrailManager couchDbAuditTrailManager(@Qualifier(value="auditActionContextCouchDbRepository") AuditActionContextCouchDbRepository repository) {
        return new CouchDbAuditTrailManager(this.casProperties.getAudit().getCouchDb().isAsynchronous(), repository);
    }

    @ConditionalOnMissingBean(name={"couchDbAuditTrailExecutionPlanConfigurer"})
    @Bean
    @RefreshScope
    public AuditTrailExecutionPlanConfigurer couchDbAuditTrailExecutionPlanConfigurer(@Qualifier(value="couchDbAuditTrailManager") AuditTrailManager auditTrailManager) {
        return plan -> plan.registerAuditTrailManager(auditTrailManager);
    }
}

