/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.couchdb.audit;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.apereo.cas.couchdb.audit.CouchDbAuditActionContext;
import org.ektorp.ComplexKey;
import org.ektorp.CouchDbConnector;
import org.ektorp.ViewQuery;
import org.ektorp.support.CouchDbRepositorySupport;
import org.ektorp.support.View;

@View(name="all", map="function(doc) { if(doc.whenActionWasPerformed) { emit(doc._id, doc) } }")
public class AuditActionContextCouchDbRepository
extends CouchDbRepositorySupport<CouchDbAuditActionContext> {
    public AuditActionContextCouchDbRepository(CouchDbConnector db, boolean createIfNotExists) {
        super(CouchDbAuditActionContext.class, db, createIfNotExists);
    }

    @View(name="by_when_action_was_performed", map="function(doc) { if(doc.whenActionWasPerformed) { emit(doc.whenActionWasPerformed, doc) } }")
    public List<CouchDbAuditActionContext> findAuditRecordsSince(LocalDate localDate) {
        return this.db.queryView(this.createQuery("by_when_action_was_performed").startKey((Object)localDate).includeDocs(true), CouchDbAuditActionContext.class);
    }

    @View(name="by_throttle_params", map="classpath:CouchDbAuditActionContext_by_throttle_params.js")
    public List<CouchDbAuditActionContext> findByThrottleParams(String remoteAddress, String username, String failureCode, String applicationCode, LocalDateTime cutoffTime) {
        ViewQuery view = this.createQuery("by_throttle_params").startKey((Object)ComplexKey.of((Object[])new Object[]{remoteAddress, username, failureCode, applicationCode, cutoffTime})).endKey((Object)ComplexKey.of((Object[])new Object[]{remoteAddress, username, failureCode, applicationCode, "999999"}));
        return this.db.queryView(view, CouchDbAuditActionContext.class);
    }
}

