/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit;

import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.dynamodb.AbstractDynamoDbProperties;
import org.apereo.cas.configuration.model.support.dynamodb.AuditDynamoDbProperties;
import org.apereo.cas.dynamodb.DynamoDbQueryBuilder;
import org.apereo.cas.dynamodb.DynamoDbTableUtils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;

public class DynamoDbAuditTrailManagerFacilitator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamoDbAuditTrailManagerFacilitator.class);
    private final AuditDynamoDbProperties dynamoDbProperties;
    private final DynamoDbClient amazonDynamoDBClient;

    private static Map<String, AttributeValue> buildTableAttributeValuesMap(AuditActionContext record) {
        HashMap<String, AttributeValue> values = new HashMap<String, AttributeValue>();
        values.put(ColumnNames.PRINCIPAL.getColumnName(), (AttributeValue)AttributeValue.builder().s(record.getPrincipal()).build());
        values.put(ColumnNames.CLIENT_IP_ADDRESS.getColumnName(), (AttributeValue)AttributeValue.builder().s(record.getClientIpAddress()).build());
        values.put(ColumnNames.SERVER_IP_ADDRESS.getColumnName(), (AttributeValue)AttributeValue.builder().s(record.getServerIpAddress()).build());
        values.put(ColumnNames.RESOURCE_OPERATED_UPON.getColumnName(), (AttributeValue)AttributeValue.builder().s(record.getResourceOperatedUpon()).build());
        values.put(ColumnNames.APPLICATION_CODE.getColumnName(), (AttributeValue)AttributeValue.builder().s(record.getApplicationCode()).build());
        values.put(ColumnNames.ACTION_PERFORMED.getColumnName(), (AttributeValue)AttributeValue.builder().s(record.getActionPerformed()).build());
        values.put(ColumnNames.USER_AGENT.getColumnName(), (AttributeValue)AttributeValue.builder().s(StringUtils.defaultString((String)record.getUserAgent(), (String)"N/A")).build());
        long time = record.getWhenActionWasPerformed().getTime();
        values.put(ColumnNames.WHEN_ACTION_PERFORMED.getColumnName(), (AttributeValue)AttributeValue.builder().s(String.valueOf(time)).build());
        LOGGER.debug("Created attribute values [{}] based on [{}]", values, (Object)record);
        return values;
    }

    public void createTable(boolean deleteTables) {
        FunctionUtils.doUnchecked(param -> {
            List<AttributeDefinition> attributes = List.of((AttributeDefinition)AttributeDefinition.builder().attributeName(ColumnNames.PRINCIPAL.getColumnName()).attributeType(ScalarAttributeType.S).build());
            List<KeySchemaElement> schema = List.of((KeySchemaElement)KeySchemaElement.builder().attributeName(ColumnNames.PRINCIPAL.getColumnName()).keyType(KeyType.HASH).build());
            DynamoDbTableUtils.createTable((DynamoDbClient)this.amazonDynamoDBClient, (AbstractDynamoDbProperties)this.dynamoDbProperties, (String)this.dynamoDbProperties.getTableName(), (boolean)deleteTables, attributes, schema);
        }, (Object[])new Object[0]);
    }

    public void save(AuditActionContext record) {
        Map<String, AttributeValue> values = DynamoDbAuditTrailManagerFacilitator.buildTableAttributeValuesMap(record);
        PutItemRequest putItemRequest = (PutItemRequest)PutItemRequest.builder().tableName(this.dynamoDbProperties.getTableName()).item(values).build();
        LOGGER.debug("Submitting put request [{}] for record [{}]", (Object)putItemRequest, (Object)record);
        PutItemResponse putItemResult = this.amazonDynamoDBClient.putItem(putItemRequest);
        LOGGER.debug("Record added with result [{}]", (Object)putItemResult);
    }

    public void removeAll() {
        this.createTable(true);
    }

    public Set<? extends AuditActionContext> getAuditRecords(Map<AuditTrailManager.WhereClauseFields, Object> whereClause) {
        LocalDate localDate = (LocalDate)whereClause.get(AuditTrailManager.WhereClauseFields.DATE);
        long time = DateTimeUtils.dateOf((LocalDate)localDate).getTime();
        List queryKeys = CollectionUtils.wrap((Object)DynamoDbQueryBuilder.builder().key(ColumnNames.WHEN_ACTION_PERFORMED.getColumnName()).attributeValue(List.of((AttributeValue)AttributeValue.builder().s(String.valueOf(time)).build())).operator(ComparisonOperator.GE).build());
        if (whereClause.containsKey(AuditTrailManager.WhereClauseFields.PRINCIPAL)) {
            queryKeys.add(DynamoDbQueryBuilder.builder().key(ColumnNames.PRINCIPAL.getColumnName()).attributeValue(List.of((AttributeValue)AttributeValue.builder().s(whereClause.get(AuditTrailManager.WhereClauseFields.PRINCIPAL).toString()).build())).operator(ComparisonOperator.EQ).build());
        }
        return DynamoDbTableUtils.getRecordsByKeys((DynamoDbClient)this.amazonDynamoDBClient, (String)this.dynamoDbProperties.getTableName(), (List)queryKeys, item -> {
            String principal = ((AttributeValue)item.get(ColumnNames.PRINCIPAL.getColumnName())).s();
            String actionPerformed = ((AttributeValue)item.get(ColumnNames.ACTION_PERFORMED.getColumnName())).s();
            String appCode = ((AttributeValue)item.get(ColumnNames.APPLICATION_CODE.getColumnName())).s();
            String clientIp = ((AttributeValue)item.get(ColumnNames.CLIENT_IP_ADDRESS.getColumnName())).s();
            String serverIp = ((AttributeValue)item.get(ColumnNames.SERVER_IP_ADDRESS.getColumnName())).s();
            String resource = ((AttributeValue)item.get(ColumnNames.RESOURCE_OPERATED_UPON.getColumnName())).s();
            String userAgent = ((AttributeValue)item.get(ColumnNames.USER_AGENT.getColumnName())).s();
            long time1 = Long.parseLong(((AttributeValue)item.get(ColumnNames.WHEN_ACTION_PERFORMED.getColumnName())).s());
            return new AuditActionContext(principal, resource, actionPerformed, appCode, new Date(time1), clientIp, serverIp, userAgent);
        }).collect(Collectors.toSet());
    }

    @Generated
    public AuditDynamoDbProperties getDynamoDbProperties() {
        return this.dynamoDbProperties;
    }

    @Generated
    public DynamoDbClient getAmazonDynamoDBClient() {
        return this.amazonDynamoDBClient;
    }

    @Generated
    public DynamoDbAuditTrailManagerFacilitator(AuditDynamoDbProperties dynamoDbProperties, DynamoDbClient amazonDynamoDBClient) {
        this.dynamoDbProperties = dynamoDbProperties;
        this.amazonDynamoDBClient = amazonDynamoDBClient;
    }

    public static enum ColumnNames {
        PRINCIPAL("principal"),
        WHEN_ACTION_PERFORMED("whenActionWasPerformed"),
        CLIENT_IP_ADDRESS("clientIpAddress"),
        SERVER_IP_ADDRESS("serverIpAddress"),
        RESOURCE_OPERATED_UPON("resourceOperatedUpon"),
        ACTION_PERFORMED("actionPerformed"),
        USER_AGENT("userAgent"),
        APPLICATION_CODE("applicationCode");

        private final String columnName;

        @Generated
        public String getColumnName() {
            return this.columnName;
        }

        @Generated
        private ColumnNames(String columnName) {
            this.columnName = columnName;
        }
    }
}

