/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.audit.AuditTrailExecutionPlanConfigurer;
import org.apereo.cas.audit.DynamoDbAuditTrailManager;
import org.apereo.cas.audit.DynamoDbAuditTrailManagerFacilitator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.dynamodb.AbstractDynamoDbProperties;
import org.apereo.cas.configuration.model.support.dynamodb.AuditDynamoDbProperties;
import org.apereo.cas.dynamodb.AmazonDynamoDbClientFactory;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.Audit, module="dynamodb")
@AutoConfiguration
public class CasSupportDynamoDbAuditConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"dynamoDbAuditTrailManager"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuditTrailManager dynamoDbAuditTrailManager(CasConfigurationProperties casProperties, @Qualifier(value="dynamoDbAuditTrailManagerFacilitator") DynamoDbAuditTrailManagerFacilitator dynamoDbAuditTrailManagerFacilitator) {
        AuditDynamoDbProperties db = casProperties.getAudit().getDynamoDb();
        return new DynamoDbAuditTrailManager(dynamoDbAuditTrailManagerFacilitator, db.isAsynchronous());
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"amazonDynamoDbAuditTrailManagerClient"})
    public DynamoDbClient amazonDynamoDbAuditTrailManagerClient(CasConfigurationProperties casProperties) {
        AuditDynamoDbProperties db = casProperties.getAudit().getDynamoDb();
        AmazonDynamoDbClientFactory factory = new AmazonDynamoDbClientFactory();
        return factory.createAmazonDynamoDb((AbstractDynamoDbProperties)db);
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"dynamoDbAuditTrailManagerFacilitator"})
    public DynamoDbAuditTrailManagerFacilitator dynamoDbAuditTrailManagerFacilitator(@Qualifier(value="amazonDynamoDbAuditTrailManagerClient") DynamoDbClient amazonDynamoDbAuditTrailManagerClient, CasConfigurationProperties casProperties) {
        AuditDynamoDbProperties db = casProperties.getAudit().getDynamoDb();
        DynamoDbAuditTrailManagerFacilitator f = new DynamoDbAuditTrailManagerFacilitator(db, amazonDynamoDbAuditTrailManagerClient);
        if (!db.isPreventTableCreationOnStartup()) {
            f.createTable(db.isDropTablesOnStartup());
        }
        return f;
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"dynamoDbAuditTrailExecutionPlanConfigurer"})
    public AuditTrailExecutionPlanConfigurer dynamoDbAuditTrailExecutionPlanConfigurer(@Qualifier(value="dynamoDbAuditTrailManager") AuditTrailManager dynamoDbAuditTrailManager) {
        return plan -> plan.registerAuditTrailManager(dynamoDbAuditTrailManager);
    }
}

