/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit;

import java.time.LocalDate;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.audit.spi.AbstractAuditTrailManager;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.inspektr.audit.AuditActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoDbAuditTrailManager
extends AbstractAuditTrailManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbAuditTrailManager.class);
    private final transient MongoTemplate mongoTemplate;
    private final String collectionName;

    public MongoDbAuditTrailManager(MongoTemplate mongoTemplate, String collectionName, boolean asynchronous) {
        super(asynchronous);
        this.mongoTemplate = mongoTemplate;
        this.collectionName = collectionName;
    }

    protected void saveAuditRecord(AuditActionContext audit) {
        this.mongoTemplate.save((Object)audit, this.collectionName);
    }

    public Set<? extends AuditActionContext> getAuditRecordsSince(LocalDate localDate) {
        Date dt = DateTimeUtils.dateOf((LocalDate)localDate);
        LOGGER.debug("Retrieving audit records since [{}] from [{}]", (Object)dt, (Object)this.collectionName);
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"whenActionWasPerformed").gte((Object)dt));
        return new LinkedHashSet(this.mongoTemplate.find(query, AuditActionContext.class, this.collectionName));
    }

    public void removeAll() {
        this.mongoTemplate.remove(new Query(), AuditActionContext.class, this.collectionName);
    }

    @Generated
    public MongoDbAuditTrailManager(MongoTemplate mongoTemplate, String collectionName) {
        this.mongoTemplate = mongoTemplate;
        this.collectionName = collectionName;
    }
}

