/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import javax.net.ssl.SSLContext;
import org.apereo.cas.audit.AuditTrailExecutionPlanConfigurer;
import org.apereo.cas.audit.MongoDbAuditTrailManager;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.audit.AuditMongoDbProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration(value="casSupportMongoDbAuditConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasSupportMongoDbAuditConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="sslContext")
    private ObjectProvider<SSLContext> sslContext;

    @Bean
    @ConditionalOnMissingBean(name={"mongoDbAuditTrailManager"})
    public AuditTrailManager mongoDbAuditTrailManager() {
        AuditMongoDbProperties mongo = this.casProperties.getAudit().getMongo();
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory((SSLContext)this.sslContext.getObject());
        MongoTemplate mongoTemplate = factory.buildMongoTemplate((BaseMongoDbProperties)mongo);
        MongoDbConnectionFactory.createCollection((MongoOperations)mongoTemplate, (String)mongo.getCollection(), (boolean)mongo.isDropCollection());
        return new MongoDbAuditTrailManager(mongoTemplate, mongo.getCollection(), mongo.isAsynchronous());
    }

    @Bean
    public AuditTrailExecutionPlanConfigurer mongoDbAuditTrailExecutionPlanConfigurer() {
        return plan -> plan.registerAuditTrailManager(this.mongoDbAuditTrailManager());
    }
}

