/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.audit.spi.AbstractAuditTrailManager;
import org.apereo.cas.redis.core.CasRedisTemplate;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisAuditTrailManager
extends AbstractAuditTrailManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisAuditTrailManager.class);
    public static final String CAS_AUDIT_CONTEXT_PREFIX = AuditActionContext.class.getSimpleName() + ":";
    private final CasRedisTemplate redisTemplate;
    private final long scanCount;

    public RedisAuditTrailManager(CasRedisTemplate redisTemplate, boolean asynchronous, long scanCount) {
        super(asynchronous);
        this.redisTemplate = Objects.requireNonNull(redisTemplate);
        this.scanCount = scanCount;
    }

    private static String getPatternAuditRedisKey(String time, String principal) {
        return CAS_AUDIT_CONTEXT_PREFIX + time + ":" + principal;
    }

    private static String getPatternAuditRedisKey() {
        return CAS_AUDIT_CONTEXT_PREFIX + "*";
    }

    public Set<? extends AuditActionContext> getAuditRecords(Map<AuditTrailManager.WhereClauseFields, Object> whereClause) {
        LocalDate localDate = (LocalDate)whereClause.get(AuditTrailManager.WhereClauseFields.DATE);
        LOGGER.debug("Retrieving audit records since [{}]", (Object)localDate);
        try (Stream<String> keys = whereClause.containsKey(AuditTrailManager.WhereClauseFields.PRINCIPAL) ? this.getAuditRedisKeys(whereClause.get(AuditTrailManager.WhereClauseFields.PRINCIPAL).toString()) : this.getAuditRedisKeys();){
            Set set = keys.map(redisKey -> this.redisTemplate.boundValueOps(redisKey).get()).filter(Objects::nonNull).map(AuditActionContext.class::cast).filter(audit -> audit.getWhenActionWasPerformed().isAfter(localDate.atStartOfDay())).collect(Collectors.toSet());
            return set;
        }
    }

    public void removeAll() {
        try (Stream<String> keys = this.getAuditRedisKeys();){
            keys.forEach(arg_0 -> ((CasRedisTemplate)this.redisTemplate).delete(arg_0));
        }
    }

    protected void saveAuditRecord(AuditActionContext audit) {
        String redisKey = RedisAuditTrailManager.getPatternAuditRedisKey(String.valueOf(audit.getWhenActionWasPerformed().toEpochSecond(ZoneOffset.UTC)), audit.getPrincipal());
        this.redisTemplate.boundValueOps((Object)redisKey).set((Object)audit);
    }

    private Stream<String> getAuditRedisKeys() {
        return this.redisTemplate.scan(RedisAuditTrailManager.getPatternAuditRedisKey(), Long.valueOf(this.scanCount));
    }

    private Stream<String> getAuditRedisKeys(String principal) {
        return this.redisTemplate.scan(RedisAuditTrailManager.getPatternAuditRedisKey("*", principal), Long.valueOf(this.scanCount));
    }

    @Generated
    public RedisAuditTrailManager(CasRedisTemplate redisTemplate, long scanCount) {
        this.redisTemplate = redisTemplate;
        this.scanCount = scanCount;
    }
}

