/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.audit.AuditTrailExecutionPlanConfigurer;
import org.apereo.cas.audit.RedisAuditTrailManager;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.redis.AuditRedisProperties;
import org.apereo.cas.configuration.model.support.redis.BaseRedisProperties;
import org.apereo.cas.redis.core.CasRedisTemplate;
import org.apereo.cas.redis.core.RedisObjectFactory;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Audit}, module="redis")
@AutoConfiguration
public class CasSupportRedisAuditAutoConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.audit.redis.enabled").isTrue().evenIfMissing();

    @Bean
    @ConditionalOnMissingBean(name={"redisAuditTrailManager"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuditTrailManager redisAuditTrailManager(ConfigurableApplicationContext applicationContext, @Qualifier(value="auditRedisTemplate") CasRedisTemplate auditRedisTemplate, CasConfigurationProperties casProperties) throws Exception {
        return (AuditTrailManager)BeanSupplier.of(AuditTrailManager.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            AuditRedisProperties redis = casProperties.getAudit().getRedis();
            return new RedisAuditTrailManager(auditRedisTemplate, redis.isAsynchronous(), redis.getScanCount());
        }).otherwiseProxy().get();
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisAuditConnectionFactory"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public RedisConnectionFactory redisAuditConnectionFactory(ConfigurableApplicationContext applicationContext, @Qualifier(value="casSslContext") CasSSLContext casSslContext, CasConfigurationProperties casProperties) throws Exception {
        return (RedisConnectionFactory)BeanSupplier.of(RedisConnectionFactory.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(Unchecked.supplier(() -> {
            AuditRedisProperties redis = casProperties.getAudit().getRedis();
            return RedisObjectFactory.newRedisConnectionFactory((BaseRedisProperties)redis, (CasSSLContext)casSslContext);
        })).otherwiseProxy().get();
    }

    @Bean
    @ConditionalOnMissingBean(name={"auditRedisTemplate"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasRedisTemplate auditRedisTemplate(ConfigurableApplicationContext applicationContext, @Qualifier(value="redisAuditConnectionFactory") RedisConnectionFactory redisAuditConnectionFactory) throws Exception {
        return (CasRedisTemplate)BeanSupplier.of(CasRedisTemplate.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> RedisObjectFactory.newRedisTemplate((RedisConnectionFactory)redisAuditConnectionFactory)).otherwiseProxy().get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"redisAuditTrailExecutionPlanConfigurer"})
    public AuditTrailExecutionPlanConfigurer redisAuditTrailExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="redisAuditTrailManager") AuditTrailManager redisAuditTrailManager) throws Exception {
        return (AuditTrailExecutionPlanConfigurer)BeanSupplier.of(AuditTrailExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerAuditTrailManager(redisAuditTrailManager)).otherwiseProxy().get();
    }
}

