/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import lombok.Generated;
import org.apereo.cas.audit.spi.BaseAuditConfigurationTests;
import org.apereo.cas.config.CasSupportRestAuditConfiguration;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.MockWebServer;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

@SpringBootTest(classes={RefreshAutoConfiguration.class, CasSupportRestAuditConfiguration.class}, properties={"cas.audit.rest.url=http://localhost:9296", "cas.audit.rest.asynchronous=false"})
@Tag(value="RestfulApi")
public class RestAuditTrailManagerTests
extends BaseAuditConfigurationTests {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestAuditTrailManagerTests.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules();
    private static final String DATA;
    @Autowired
    @Qualifier(value="restAuditTrailManager")
    private AuditTrailManager auditTrailManager;

    @Test
    public void verifyAuditManager() {
        try (MockWebServer webServer = new MockWebServer(9296, (Resource)new ByteArrayResource(DATA.getBytes(StandardCharsets.UTF_8), "REST Output"), "application/json");){
            webServer.start();
            Assertions.assertTrue((boolean)webServer.isRunning());
            super.verifyAuditManager();
        }
    }

    @Generated
    public AuditTrailManager getAuditTrailManager() {
        return this.auditTrailManager;
    }

    static {
        AuditActionContext audit = new AuditActionContext("casuser", "resource", "action", "CAS", new Date(), "123.456.789.000", "123.456.789.000");
        try {
            DATA = MAPPER.writeValueAsString((Object)CollectionUtils.wrapSet((Object)audit));
            LOGGER.debug("DATA: [{}]", (Object)DATA);
        }
        catch (JsonProcessingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

