/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.audit.spi.AbstractAuditTrailManager;
import org.apereo.cas.audit.spi.AuditActionContextJsonSerializer;
import org.apereo.cas.configuration.model.core.audit.AuditRestProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.inspektr.audit.AuditActionContext;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAuditTrailManager
extends AbstractAuditTrailManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestAuditTrailManager.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules();
    private final AuditActionContextJsonSerializer serializer = new AuditActionContextJsonSerializer();
    private final AuditRestProperties properties;

    public RestAuditTrailManager(AuditRestProperties properties) {
        super(properties.isAsynchronous());
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAuditRecord(AuditActionContext audit) {
        HttpResponse response = null;
        try {
            String auditJson = this.serializer.toString((Object)audit);
            LOGGER.trace("Sending audit action context to REST endpoint [{}]", (Object)this.properties.getUrl());
            response = HttpUtils.executePost((String)this.properties.getUrl(), (String)this.properties.getBasicAuthUsername(), (String)this.properties.getBasicAuthPassword(), (String)auditJson);
        }
        catch (Throwable throwable) {
            HttpUtils.close(response);
            throw throwable;
        }
        HttpUtils.close((HttpResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<? extends AuditActionContext> getAuditRecordsSince(LocalDate localDate) {
        HttpResponse response = null;
        try {
            LOGGER.debug("Sending query to audit REST endpoint to fetch records from [{}]", (Object)localDate);
            response = HttpUtils.executeGet((String)this.properties.getUrl(), (String)this.properties.getBasicAuthUsername(), (String)this.properties.getBasicAuthPassword(), (Map)CollectionUtils.wrap((String)"date", (Object)String.valueOf(localDate.toEpochDay())));
            if (response != null && response.getStatusLine().getStatusCode() == 200) {
                String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                TypeReference<Set<AuditActionContext>> values = new TypeReference<Set<AuditActionContext>>(){};
                Set set = (Set)MAPPER.readValue(JsonValue.readHjson((String)result).toString(), (TypeReference)values);
                HttpUtils.close((HttpResponse)response);
                return set;
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
        return new HashSet(0);
    }

    public void removeAll() {
        HttpResponse response = null;
        try {
            LOGGER.debug("Sending query to audit REST endpoint to delete records");
            response = HttpUtils.executeDelete((String)this.properties.getUrl(), (String)this.properties.getBasicAuthUsername(), (String)this.properties.getBasicAuthPassword());
            if (response != null && response.getStatusLine().getStatusCode() == 200) {
                LOGGER.debug("Deleted audit records successfully");
            }
        }
        catch (Throwable throwable) {
            HttpUtils.close(response);
            throw throwable;
        }
        HttpUtils.close((HttpResponse)response);
    }
}

