/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.audit.AuditTrailExecutionPlanConfigurer;
import org.apereo.cas.audit.RestAuditTrailManager;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.audit.AuditRestProperties;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casSupportRestAuditConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasSupportRestAuditConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    @ConditionalOnMissingBean(name={"restAuditTrailManager"})
    @RefreshScope
    public AuditTrailManager restAuditTrailManager() {
        AuditRestProperties rest = this.casProperties.getAudit().getRest();
        return new RestAuditTrailManager(rest);
    }

    @Bean
    @ConditionalOnMissingBean(name={"restAuditTrailExecutionPlanConfigurer"})
    public AuditTrailExecutionPlanConfigurer restAuditTrailExecutionPlanConfigurer() {
        return plan -> plan.registerAuditTrailManager(this.restAuditTrailManager());
    }
}

