/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.config.CasSupportRestAuditConfiguration;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.MockWebServer;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;

@SpringBootTest(classes={RefreshAutoConfiguration.class, CasSupportRestAuditConfiguration.class}, properties={"cas.audit.rest.url=http://localhost:9296", "cas.audit.rest.asynchronous=false"})
@Tag(value="RestfulApi")
public class RestAuditTrailManagerTests {
    private static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules();
    @Autowired
    @Qualifier(value="restAuditTrailManager")
    private AuditTrailManager auditTrailManager;

    @Test
    public void verifyRemoval() {
        try (MockWebServer webServer = new MockWebServer(9296, (Resource)new ByteArrayResource(ArrayUtils.EMPTY_BYTE_ARRAY), HttpStatus.OK);){
            webServer.start();
            Assertions.assertTrue((boolean)webServer.isRunning());
            this.auditTrailManager.removeAll();
        }
    }

    @Test
    public void verifyGet() throws Exception {
        AuditActionContext audit = new AuditActionContext("casuser", "resource", "action", "CAS", new Date(), "123.456.789.000", "123.456.789.000");
        String data = MAPPER.writeValueAsString((Object)CollectionUtils.wrapSet((Object)audit));
        try (MockWebServer webServer = new MockWebServer(9296, (Resource)new ByteArrayResource(data.getBytes(StandardCharsets.UTF_8)), HttpStatus.OK);){
            webServer.start();
            Assertions.assertTrue((boolean)webServer.isRunning());
            this.auditTrailManager.record(audit);
            LocalDate time = LocalDate.now(ZoneOffset.UTC).minusDays(2L);
            Set results = this.auditTrailManager.getAuditRecordsSince(time);
            Assertions.assertFalse((boolean)results.isEmpty());
        }
    }

    @Generated
    public AuditTrailManager getAuditTrailManager() {
        return this.auditTrailManager;
    }
}

