/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.aup.AcceptableUsagePolicyRepository;
import org.apereo.cas.aup.DefaultAcceptableUsagePolicyRepository;
import org.apereo.cas.aup.GroovyAcceptableUsagePolicyRepository;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.aup.GroovyAcceptableUsagePolicyProperties;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.scripting.WatchableGroovyScriptResource;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.AcceptableUsagePolicySubmitAction;
import org.apereo.cas.web.flow.AcceptableUsagePolicyVerifyAction;
import org.apereo.cas.web.flow.AcceptableUsagePolicyVerifyServiceAction;
import org.apereo.cas.web.flow.AcceptableUsagePolicyWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.AcceptableUsagePolicy})
@AutoConfiguration
public class CasAcceptableUsagePolicyWebflowConfiguration {

    @Configuration(value="CasAcceptableUsagePolicyWebflowAuditConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasAcceptableUsagePolicyWebflowAuditConfiguration {
        @ConditionalOnMissingBean(name={"casAcceptableUsagePolicyAuditTrailRecordResolutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlanConfigurer casAcceptableUsagePolicyAuditTrailRecordResolutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="nullableReturnValueResourceResolver") AuditResourceResolver resourceResolver) throws Exception {
            return (AuditTrailRecordResolutionPlanConfigurer)BeanSupplier.of(AuditTrailRecordResolutionPlanConfigurer.class).when(AcceptableUsagePolicyRepository.CONDITION_AUP_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
                plan.registerAuditResourceResolver(resourceResolver, new String[]{"AUP_SUBMIT_RESOURCE_RESOLVER", "AUP_VERIFY_RESOURCE_RESOLVER"});
                DefaultAuditActionResolver resolver = new DefaultAuditActionResolver("_TRIGGERED");
                plan.registerAuditActionResolvers((AuditActionResolver)resolver, new String[]{"AUP_VERIFY_ACTION_RESOLVER", "AUP_SUBMIT_ACTION_RESOLVER"});
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasAcceptableUsagePolicyWebflowActionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasAcceptableUsagePolicyWebflowActionConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"acceptableUsagePolicySubmitAction"})
        public Action acceptableUsagePolicySubmitAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="acceptableUsagePolicyRepository") AcceptableUsagePolicyRepository acceptableUsagePolicyRepository) throws Exception {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).when(AcceptableUsagePolicyRepository.CONDITION_AUP_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new AcceptableUsagePolicySubmitAction(acceptableUsagePolicyRepository)).otherwise(() -> ConsumerExecutionAction.NONE).get()).withId("acceptableUsagePolicySubmitAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"acceptableUsagePolicyVerifyAction"})
        public Action acceptableUsagePolicyVerifyAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="acceptableUsagePolicyRepository") AcceptableUsagePolicyRepository acceptableUsagePolicyRepository, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer) throws Exception {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).when(AcceptableUsagePolicyRepository.CONDITION_AUP_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new AcceptableUsagePolicyVerifyAction(acceptableUsagePolicyRepository, registeredServiceAccessStrategyEnforcer)).otherwise(() -> ConsumerExecutionAction.NONE).get()).withId("acceptableUsagePolicyVerifyAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"acceptableUsagePolicyRenderAction"})
        public Action acceptableUsagePolicyRenderAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="acceptableUsagePolicyRepository") AcceptableUsagePolicyRepository acceptableUsagePolicyRepository) throws Exception {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).when(AcceptableUsagePolicyRepository.CONDITION_AUP_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new ConsumerExecutionAction(requestContext -> acceptableUsagePolicyRepository.fetchPolicy(requestContext).ifPresent(policy -> WebUtils.putAcceptableUsagePolicyTermsIntoFlowScope((RequestContext)requestContext, (Object)policy)))).otherwise(() -> ConsumerExecutionAction.NONE).get()).withId("acceptableUsagePolicyRenderAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"acceptableUsagePolicyVerifyServiceAction"})
        public Action acceptableUsagePolicyVerifyServiceAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="acceptableUsagePolicyRepository") AcceptableUsagePolicyRepository acceptableUsagePolicyRepository, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer) throws Exception {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).when(AcceptableUsagePolicyRepository.CONDITION_AUP_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new AcceptableUsagePolicyVerifyServiceAction(acceptableUsagePolicyRepository, registeredServiceAccessStrategyEnforcer)).otherwise(() -> ConsumerExecutionAction.NONE).get()).withId("acceptableUsagePolicyVerifyServiceAction").build().get();
        }
    }

    @Configuration(value="CasAcceptableUsagePolicyWebflowPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasAcceptableUsagePolicyWebflowPlanConfiguration {
        @ConditionalOnMissingBean(name={"casAcceptableUsagePolicyWebflowExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer casAcceptableUsagePolicyWebflowExecutionPlanConfigurer(@Qualifier(value="acceptableUsagePolicyWebflowConfigurer") CasWebflowConfigurer acceptableUsagePolicyWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(acceptableUsagePolicyWebflowConfigurer);
        }
    }

    @Configuration(value="CasAcceptableUsagePolicyWebflowRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasAcceptableUsagePolicyWebflowRepositoryConfiguration {
        @ConditionalOnMissingBean(name={"acceptableUsagePolicyRepository"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AcceptableUsagePolicyRepository acceptableUsagePolicyRepository(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport) throws Exception {
            return (AcceptableUsagePolicyRepository)BeanSupplier.of(AcceptableUsagePolicyRepository.class).when(AcceptableUsagePolicyRepository.CONDITION_AUP_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                GroovyAcceptableUsagePolicyProperties groovy = casProperties.getAcceptableUsagePolicy().getGroovy();
                if (groovy.getLocation() != null) {
                    return new GroovyAcceptableUsagePolicyRepository(ticketRegistrySupport, casProperties.getAcceptableUsagePolicy(), new WatchableGroovyScriptResource(groovy.getLocation()), (ApplicationContext)applicationContext);
                }
                return new DefaultAcceptableUsagePolicyRepository(ticketRegistrySupport, casProperties.getAcceptableUsagePolicy());
            }).otherwise(AcceptableUsagePolicyRepository::noOp).get();
        }
    }

    @Configuration(value="CasAcceptableUsagePolicyWebflowCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasAcceptableUsagePolicyWebflowCoreConfiguration {
        @ConditionalOnMissingBean(name={"acceptableUsagePolicyWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer acceptableUsagePolicyWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(AcceptableUsagePolicyRepository.CONDITION_AUP_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new AcceptableUsagePolicyWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties)).otherwiseProxy().get();
        }
    }
}

