/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.aup.AcceptableUsagePolicyRepository;
import org.apereo.cas.aup.AcceptableUsagePolicyStatus;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.WebBasedRegisteredService;
import org.apereo.cas.util.model.TriStateBoolean;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AcceptableUsagePolicyVerifyAction
extends BaseCasWebflowAction {
    private final AcceptableUsagePolicyRepository repository;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;

    @Audit(action="AUP_VERIFY", actionResolverName="AUP_VERIFY_ACTION_RESOLVER", resourceResolverName="AUP_VERIFY_RESOURCE_RESOLVER")
    public Event doExecute(RequestContext requestContext) {
        return this.verify(requestContext);
    }

    private Event verify(RequestContext context) {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
        AcceptableUsagePolicyStatus res = (AcceptableUsagePolicyStatus)ObjectUtils.defaultIfNull((Object)this.repository.verify(context), (Object)AcceptableUsagePolicyStatus.skipped((Principal)authentication.getPrincipal()));
        WebUtils.putPrincipal((RequestContext)context, (Principal)res.getPrincipal());
        WebUtils.putAcceptableUsagePolicyStatusIntoFlowScope((RequestContext)context, (Object)res);
        EventFactorySupport eventFactorySupport = new EventFactorySupport();
        WebBasedRegisteredService registeredService = (WebBasedRegisteredService)WebUtils.getRegisteredService((RequestContext)context);
        if (registeredService != null) {
            boolean aupEnabled;
            WebApplicationService service = WebUtils.getService((RequestContext)context);
            AuditableContext audit = AuditableContext.builder().service((Service)service).authentication(authentication).registeredService((RegisteredService)registeredService).build();
            AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
            accessResult.throwExceptionIfNeeded();
            boolean bl = aupEnabled = registeredService.getAcceptableUsagePolicy() != null && registeredService.getAcceptableUsagePolicy().isEnabled();
            if (!aupEnabled) {
                return eventFactorySupport.event((Object)this, "acceptedUsagePolicy");
            }
        }
        return switch (res.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case TriStateBoolean.TRUE -> eventFactorySupport.event((Object)this, "acceptedUsagePolicy");
            case TriStateBoolean.FALSE -> eventFactorySupport.event((Object)this, "mustAcceptUsagePolicy");
            case TriStateBoolean.UNDEFINED -> eventFactorySupport.event((Object)this, "skip");
        };
    }

    @Generated
    public AcceptableUsagePolicyVerifyAction(AcceptableUsagePolicyRepository repository, AuditableExecution registeredServiceAccessStrategyEnforcer) {
        this.repository = repository;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }
}

