/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.authy;

import com.authy.AuthyException;
import com.authy.api.Token;
import com.authy.api.Tokens;
import com.authy.api.User;
import javax.security.auth.login.FailedLoginException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.adaptors.authy.AuthyAuthenticationHandler;
import org.apereo.cas.adaptors.authy.AuthyClientInstance;
import org.apereo.cas.adaptors.authy.AuthyTokenCredential;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="MFA")
public class AuthyAuthenticationHandlerTests {
    @Test
    public void verifyOperation() throws Exception {
        AuthyClientInstance authyInstance = AuthyAuthenticationHandlerTests.configureAuthyClientInstance(200, 200, "Token is valid.");
        AuthyAuthenticationHandler handler = new AuthyAuthenticationHandler("Authy", (ServicesManager)Mockito.mock(ServicesManager.class), PrincipalFactoryUtils.newPrincipalFactory(), authyInstance, true, Integer.valueOf(0));
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        WebUtils.putAuthentication((Authentication)CoreAuthenticationTestUtils.getAuthentication(), (RequestContext)context);
        AuthenticationHandlerExecutionResult result = handler.authenticate((Credential)new AuthyTokenCredential("token"));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)handler.supports((Credential)new AuthyTokenCredential("token")));
        Assertions.assertTrue((boolean)handler.supports(AuthyTokenCredential.class));
    }

    @Test
    public void verifyFailsOperation() throws Exception {
        AuthyClientInstance authyInstance = AuthyAuthenticationHandlerTests.configureAuthyClientInstance(400, 200, "Token is valid.");
        AuthyAuthenticationHandler handler = new AuthyAuthenticationHandler("Authy", (ServicesManager)Mockito.mock(ServicesManager.class), PrincipalFactoryUtils.newPrincipalFactory(), authyInstance, true, Integer.valueOf(0));
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        Assertions.assertThrows(IllegalArgumentException.class, () -> handler.authenticate((Credential)new AuthyTokenCredential("token")));
        WebUtils.putAuthentication((Authentication)CoreAuthenticationTestUtils.getAuthentication(), (RequestContext)context);
        Assertions.assertThrows(FailedLoginException.class, () -> handler.authenticate((Credential)new AuthyTokenCredential("token")));
    }

    @Test
    public void verifyFailsVerify() throws Exception {
        AuthyClientInstance authyInstance = AuthyAuthenticationHandlerTests.configureAuthyClientInstance(200, 400, "Bad");
        AuthyAuthenticationHandler handler = new AuthyAuthenticationHandler("Authy", (ServicesManager)Mockito.mock(ServicesManager.class), PrincipalFactoryUtils.newPrincipalFactory(), authyInstance, true, Integer.valueOf(0));
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        WebUtils.putAuthentication((Authentication)CoreAuthenticationTestUtils.getAuthentication(), (RequestContext)context);
        Assertions.assertThrows(FailedLoginException.class, () -> handler.authenticate((Credential)new AuthyTokenCredential("token")));
    }

    private static AuthyClientInstance configureAuthyClientInstance(int userStatus, int tokenStatus, String message) throws AuthyException {
        AuthyClientInstance authyInstance = (AuthyClientInstance)Mockito.mock(AuthyClientInstance.class);
        Tokens tokens = (Tokens)Mockito.mock(Tokens.class);
        Token token = new Token(tokenStatus, "OK", message);
        Mockito.when((Object)tokens.verify(Mockito.eq((int)123456), (String)Mockito.eq((Object)"token"), Mockito.anyMap())).thenReturn((Object)token);
        Mockito.when((Object)authyInstance.getAuthyTokens()).thenReturn((Object)tokens);
        User user = new User(userStatus, "token");
        user.setId(123456);
        Mockito.when((Object)authyInstance.getOrCreateUser((Principal)Mockito.any(Principal.class))).thenReturn((Object)user);
        return authyInstance;
    }
}

