/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.authy.web.flow;

import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.adaptors.authy.AuthyTokenCredential;
import org.apereo.cas.adaptors.authy.BaseAuthyAuthenticationTests;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.message.MessageContext;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

@Tag(value="WebflowEvents")
@SpringBootTest(classes={BaseAuthyAuthenticationTests.SharedTestConfiguration.class}, properties={"cas.authn.mfa.authy.api-key=example", "cas.authn.mfa.authy.api-url=http://localhost:8080/authy"})
public class AuthyAuthenticationWebflowEventResolverTests {
    @Autowired
    @Qualifier(value="authyAuthenticationWebflowEventResolver")
    private CasWebflowEventResolver resolver;

    @Test
    public void verifyOperation() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        RequestContext context = (RequestContext)Mockito.mock(RequestContext.class);
        Mockito.when((Object)context.getMessageContext()).thenReturn((Object)((MessageContext)Mockito.mock(MessageContext.class)));
        Mockito.when((Object)context.getConversationScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)context.getFlowScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)context.getRequestScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)context.getFlashScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)context.getExternalContext()).thenReturn((Object)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        WebUtils.putCredential((RequestContext)context, (Credential)new AuthyTokenCredential("token"));
        Authentication authn = RegisteredServiceTestUtils.getAuthentication((String)"casuser");
        AuthenticationResultBuilder builder = (AuthenticationResultBuilder)Mockito.mock(AuthenticationResultBuilder.class);
        Mockito.when((Object)builder.getInitialAuthentication()).thenReturn(Optional.of(authn));
        Mockito.when((Object)builder.collect((Authentication)Mockito.any(Authentication.class))).thenReturn((Object)builder);
        WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)builder, (RequestContext)context);
        WebUtils.putAuthentication((Authentication)authn, (RequestContext)context);
        Event event = this.resolver.resolveSingle(context);
        Assertions.assertEquals((Object)"error", (Object)event.getId());
    }
}

