/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.authy.config;

import org.apereo.cas.adaptors.authy.web.flow.AuthyAuthenticationWebflowAction;
import org.apereo.cas.adaptors.authy.web.flow.AuthyAuthenticationWebflowEventResolver;
import org.apereo.cas.adaptors.authy.web.flow.AuthyMultifactorTrustedDeviceWebflowConfigurer;
import org.apereo.cas.adaptors.authy.web.flow.AuthyMultifactorWebflowConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.trusted.config.ConditionalOnMultifactorTrustedDevicesEnabled;
import org.apereo.cas.trusted.config.MultifactorAuthnTrustConfiguration;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="authyConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class AuthyConfiguration {
    private static final int WEBFLOW_CONFIGURER_ORDER = 100;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    @Qualifier(value="casWebflowConfigurationContext")
    private ObjectProvider<CasWebflowEventResolutionConfigurationContext> casWebflowConfigurationContext;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="flowBuilder")
    private ObjectProvider<FlowBuilder> flowBuilder;

    @Bean
    @ConditionalOnMissingBean(name={"authyAuthenticatorFlowRegistry"})
    public FlowDefinitionRegistry authyAuthenticatorFlowRegistry() {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)this.applicationContext, (FlowBuilderServices)this.flowBuilderServices.getObject());
        builder.addFlowBuilder((FlowBuilder)this.flowBuilder.getObject(), "mfa-authy");
        return builder.build();
    }

    @RefreshScope
    @Bean
    public CasWebflowEventResolver authyAuthenticationWebflowEventResolver() {
        return new AuthyAuthenticationWebflowEventResolver((CasWebflowEventResolutionConfigurationContext)this.casWebflowConfigurationContext.getObject());
    }

    @ConditionalOnMissingBean(name={"authyMultifactorWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer authyMultifactorWebflowConfigurer() {
        AuthyMultifactorWebflowConfigurer cfg = new AuthyMultifactorWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.authyAuthenticatorFlowRegistry(), this.applicationContext, this.casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)this.applicationContext));
        cfg.setOrder(100);
        return cfg;
    }

    @RefreshScope
    @Bean
    public Action authyAuthenticationWebflowAction() {
        return new AuthyAuthenticationWebflowAction(this.authyAuthenticationWebflowEventResolver());
    }

    @Bean
    @ConditionalOnMissingBean(name={"authyCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer authyCasWebflowExecutionPlanConfigurer() {
        return plan -> plan.registerWebflowConfigurer(this.authyMultifactorWebflowConfigurer());
    }

    @ConditionalOnClass(value={MultifactorAuthnTrustConfiguration.class})
    @ConditionalOnMultifactorTrustedDevicesEnabled(prefix="cas.authn.mfa.authy")
    @Configuration(value="authyMultifactorTrustConfiguration")
    public class AuthyMultifactorTrustConfiguration {
        @ConditionalOnMissingBean(name={"authyMultifactorTrustWebflowConfigurer"})
        @Bean
        @DependsOn(value={"defaultWebflowConfigurer"})
        public CasWebflowConfigurer authyMultifactorTrustWebflowConfigurer() {
            AuthyMultifactorTrustedDeviceWebflowConfigurer cfg = new AuthyMultifactorTrustedDeviceWebflowConfigurer((FlowBuilderServices)AuthyConfiguration.this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)AuthyConfiguration.this.loginFlowDefinitionRegistry.getObject(), AuthyConfiguration.this.authyAuthenticatorFlowRegistry(), AuthyConfiguration.this.applicationContext, AuthyConfiguration.this.casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)AuthyConfiguration.this.applicationContext));
            cfg.setOrder(101);
            return cfg;
        }

        @Bean
        @ConditionalOnMissingBean(name={"authyMultifactorTrustCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer authyMultifactorTrustCasWebflowExecutionPlanConfigurer() {
            return plan -> plan.registerWebflowConfigurer(this.authyMultifactorTrustWebflowConfigurer());
        }
    }
}

