/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.authy.config.support.authentication;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.authy.AuthyAuthenticationHandler;
import org.apereo.cas.adaptors.authy.AuthyClientInstance;
import org.apereo.cas.adaptors.authy.AuthyMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.authy.AuthyTokenCredential;
import org.apereo.cas.adaptors.authy.web.flow.AuthyAuthenticationRegistrationWebflowAction;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.handler.ByCredentialTypeAuthenticationHandlerResolver;
import org.apereo.cas.authentication.metadata.AuthenticationContextAttributeMetaDataPopulator;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.AuthyMultifactorAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.webflow.execution.Action;

@Configuration(value="authyAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnProperty(prefix="cas.authn.mfa.authy", name={"api-key"})
public class AuthyAuthenticationEventExecutionPlanConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="authyBypassEvaluator")
    private ObjectProvider<MultifactorAuthenticationProviderBypassEvaluator> authyBypassEvaluator;
    @Autowired
    @Qualifier(value="failureModeEvaluator")
    private ObjectProvider<MultifactorAuthenticationFailureModeEvaluator> failureModeEvaluator;

    @RefreshScope
    @Bean
    public AuthyClientInstance authyClientInstance() {
        AuthyMultifactorAuthenticationProperties authy = this.casProperties.getAuthn().getMfa().getAuthy();
        if (StringUtils.isBlank((CharSequence)authy.getApiKey())) {
            throw new IllegalArgumentException("Authy API key must be defined");
        }
        return new AuthyClientInstance(authy);
    }

    @ConditionalOnMissingBean(name={"authyAuthenticationHandler"})
    @RefreshScope
    @Bean
    public AuthenticationHandler authyAuthenticationHandler() {
        AuthyMultifactorAuthenticationProperties authy = this.casProperties.getAuthn().getMfa().getAuthy();
        boolean forceVerification = authy.isForceVerification();
        return new AuthyAuthenticationHandler(authy.getName(), (ServicesManager)this.servicesManager.getObject(), this.authyPrincipalFactory(), this.authyClientInstance(), forceVerification, authy.getOrder());
    }

    @ConditionalOnMissingBean(name={"authyPrincipalFactory"})
    @Bean
    public PrincipalFactory authyPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @RefreshScope
    public MultifactorAuthenticationProvider authyAuthenticatorMultifactorAuthenticationProvider() {
        AuthyMultifactorAuthenticationProvider p = new AuthyMultifactorAuthenticationProvider();
        p.setBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)this.authyBypassEvaluator.getObject());
        AuthyMultifactorAuthenticationProperties authy = this.casProperties.getAuthn().getMfa().getAuthy();
        p.setFailureMode(authy.getFailureMode());
        p.setFailureModeEvaluator((MultifactorAuthenticationFailureModeEvaluator)this.failureModeEvaluator.getObject());
        p.setOrder(authy.getRank());
        p.setId(authy.getId());
        return p;
    }

    @Bean
    @RefreshScope
    public AuthenticationMetaDataPopulator authyAuthenticationMetaDataPopulator() {
        return new AuthenticationContextAttributeMetaDataPopulator(this.casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute(), this.authyAuthenticationHandler(), this.authyAuthenticatorMultifactorAuthenticationProvider().getId());
    }

    @RefreshScope
    @Bean
    public Action authyAuthenticationRegistrationWebflowAction() {
        return new AuthyAuthenticationRegistrationWebflowAction(this.authyClientInstance());
    }

    @ConditionalOnMissingBean(name={"authyAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer authyAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            plan.registerAuthenticationHandler(this.authyAuthenticationHandler());
            plan.registerAuthenticationMetadataPopulator(this.authyAuthenticationMetaDataPopulator());
            plan.registerAuthenticationHandlerResolver((AuthenticationHandlerResolver)new ByCredentialTypeAuthenticationHandlerResolver(new Class[]{AuthyTokenCredential.class}));
        };
    }
}

