/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.authy.web.flow;

import com.authy.api.Error;
import com.authy.api.Hash;
import com.authy.api.User;
import lombok.Generated;
import org.apereo.cas.adaptors.authy.AuthyClientInstance;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AuthyAuthenticationRegistrationWebflowAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthyAuthenticationRegistrationWebflowAction.class);
    private static final String MESSAGE_CODE_ERROR = "cas.mfa.authy.error.authn";
    private final AuthyClientInstance instance;

    protected Event doExecute(RequestContext context) {
        Principal principal = WebUtils.getAuthentication((RequestContext)context).getPrincipal();
        User user = this.instance.getOrCreateUser(principal);
        if (!user.isOk()) {
            IllegalArgumentException ex = new IllegalArgumentException(AuthyClientInstance.getErrorMessage((Error)user.getError()));
            this.addErrorMessage(context, ex);
            LoggingUtils.error((Logger)LOGGER, (Throwable)ex);
            return this.error(ex);
        }
        Hash h = this.submitAuthyRegistrationRequest(user);
        if (!h.isOk() || !h.isSuccess()) {
            IllegalArgumentException ex = new IllegalArgumentException(AuthyClientInstance.getErrorMessage((Error)h.getError()).concat(h.getMessage()));
            LoggingUtils.error((Logger)LOGGER, (Throwable)ex);
            return this.error(ex);
        }
        return this.success();
    }

    protected void addErrorMessage(RequestContext requestContext, Exception exception) {
        WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)MESSAGE_CODE_ERROR, (String)exception.getMessage());
    }

    private Hash submitAuthyRegistrationRequest(User user) {
        return this.instance.getAuthyUsers().requestSms(user.getId());
    }

    @Generated
    public AuthyAuthenticationRegistrationWebflowAction(AuthyClientInstance instance) {
        this.instance = instance;
    }
}

