/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.authy.web.flow;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apereo.cas.adaptors.authy.AuthyTokenCredential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.configurer.AbstractCasMultifactorWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.SetAction;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class AuthyMultifactorWebflowConfigurer
extends AbstractCasMultifactorWebflowConfigurer {
    public static final String MFA_AUTHY_EVENT_ID = "mfa-authy";

    public AuthyMultifactorWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, FlowDefinitionRegistry flowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, List<CasMultifactorWebflowCustomizer> mfaFlowCustomizers) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties, Optional.of(flowDefinitionRegistry), mfaFlowCustomizers);
    }

    protected void doInitialize() {
        this.multifactorAuthenticationFlowDefinitionRegistries.forEach(registry -> {
            Flow flow = this.getFlow((FlowDefinitionRegistry)registry, MFA_AUTHY_EVENT_ID);
            this.createFlowVariable(flow, "credential", AuthyTokenCredential.class);
            flow.getStartActionList().add((Action)this.createEvaluateAction("initialFlowSetupAction"));
            this.createEndState(flow, "success");
            ActionState initLoginFormState = this.createActionState(flow, "initializeLoginForm", (Action)this.createEvaluateAction("initializeLoginAction"));
            this.createTransitionForState((TransitionableState)initLoginFormState, "success", "registerUserAction");
            this.setStartState(flow, (TransitionableState)initLoginFormState);
            ActionState registerState = this.createActionState(flow, "registerUserAction", (Action)this.createEvaluateAction("authyAuthenticationRegistrationWebflowAction"));
            this.createStateDefaultTransition((TransitionableState)registerState, "viewLoginForm");
            ActionState realSubmitState = this.createActionState(flow, "realSubmit", (Action)this.createEvaluateAction("authyAuthenticationWebflowAction"));
            this.createTransitionForState((TransitionableState)realSubmitState, "success", "success");
            this.createTransitionForState((TransitionableState)realSubmitState, "error", "viewLoginForm");
            SetAction setPrincipalAction = this.createSetAction("viewScope.principal", "conversationScope.authentication.principal");
            List loginProperties = CollectionUtils.wrapList((Object[])new String[]{"token"});
            BinderConfiguration loginBinder = this.createStateBinderConfiguration(loginProperties);
            ViewState viewLoginFormState = this.createViewState(flow, "viewLoginForm", "authy/casAuthyLoginView", loginBinder);
            this.createStateModelBinding((TransitionableState)viewLoginFormState, "credential", AuthyTokenCredential.class);
            viewLoginFormState.getEntryActionList().addAll(new Action[]{setPrincipalAction});
            this.createTransitionForState((TransitionableState)viewLoginFormState, "submit", "realSubmit", Map.of("bind", Boolean.TRUE, "validate", Boolean.TRUE));
        });
        this.registerMultifactorProviderAuthenticationWebflow(this.getLoginFlow(), MFA_AUTHY_EVENT_ID, this.casProperties.getAuthn().getMfa().getAuthy().getId());
    }
}

