/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.authy;

import com.authy.AuthyApiClient;
import com.authy.api.Token;
import com.authy.api.Tokens;
import com.authy.api.User;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import javax.security.auth.login.FailedLoginException;
import org.apereo.cas.adaptors.authy.AuthyAuthenticationHandler;
import org.apereo.cas.adaptors.authy.AuthyClientInstance;
import org.apereo.cas.adaptors.authy.AuthyTokenCredential;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.spring.DirectObjectProvider;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="MFAProvider")
public class AuthyAuthenticationHandlerTests {
    private static AuthyClientInstance configureAuthyClientInstance(int userStatus, int tokenStatus, String message) throws Exception {
        AuthyClientInstance authyInstance = (AuthyClientInstance)Mockito.mock(AuthyClientInstance.class);
        AuthyApiClient apiClient = (AuthyApiClient)Mockito.mock(AuthyApiClient.class);
        Mockito.when((Object)authyInstance.authyClient()).thenReturn((Object)apiClient);
        Tokens tokens = (Tokens)Mockito.mock(Tokens.class);
        Token token = new Token(tokenStatus, "OK", message);
        Mockito.when((Object)tokens.verify(Mockito.eq((int)123456), (String)Mockito.eq((Object)"token"), Mockito.anyMap())).thenReturn((Object)token);
        Mockito.when((Object)apiClient.getTokens()).thenReturn((Object)tokens);
        User user = new User(userStatus, "token");
        user.setId(123456);
        Mockito.when((Object)authyInstance.getOrCreateUser((Principal)Mockito.any(Principal.class))).thenReturn((Object)user);
        return authyInstance;
    }

    @Test
    public void verifyOperation() throws Exception {
        AuthyClientInstance authyInstance = AuthyAuthenticationHandlerTests.configureAuthyClientInstance(200, 200, "Token is valid.");
        AuthyAuthenticationHandler handler = AuthyAuthenticationHandlerTests.getAuthyAuthenticationHandler(authyInstance);
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        WebUtils.putAuthentication((Authentication)CoreAuthenticationTestUtils.getAuthentication(), (RequestContext)context);
        AuthenticationHandlerExecutionResult result = handler.authenticate((Credential)new AuthyTokenCredential("token"), (Service)Mockito.mock(Service.class));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)handler.supports((Credential)new AuthyTokenCredential("token")));
        Assertions.assertTrue((boolean)handler.supports(AuthyTokenCredential.class));
    }

    @Test
    public void verifyFailsOperation() throws Exception {
        AuthyClientInstance authyInstance = AuthyAuthenticationHandlerTests.configureAuthyClientInstance(400, 200, "Token is valid.");
        AuthyAuthenticationHandler handler = AuthyAuthenticationHandlerTests.getAuthyAuthenticationHandler(authyInstance);
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        Assertions.assertThrows(NullPointerException.class, () -> handler.authenticate((Credential)new AuthyTokenCredential("token"), (Service)Mockito.mock(Service.class)));
        WebUtils.putAuthentication((Authentication)CoreAuthenticationTestUtils.getAuthentication(), (RequestContext)context);
        Assertions.assertThrows(FailedLoginException.class, () -> handler.authenticate((Credential)new AuthyTokenCredential("token"), (Service)Mockito.mock(Service.class)));
    }

    @Test
    public void verifyFailsVerify() throws Exception {
        AuthyClientInstance authyInstance = AuthyAuthenticationHandlerTests.configureAuthyClientInstance(200, 400, "Bad");
        AuthyAuthenticationHandler handler = AuthyAuthenticationHandlerTests.getAuthyAuthenticationHandler(authyInstance);
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        WebUtils.putAuthentication((Authentication)CoreAuthenticationTestUtils.getAuthentication(), (RequestContext)context);
        Assertions.assertThrows(FailedLoginException.class, () -> handler.authenticate((Credential)new AuthyTokenCredential("token"), (Service)Mockito.mock(Service.class)));
    }

    private static AuthyAuthenticationHandler getAuthyAuthenticationHandler(AuthyClientInstance authyInstance) {
        return new AuthyAuthenticationHandler("Authy", (ServicesManager)Mockito.mock(ServicesManager.class), PrincipalFactoryUtils.newPrincipalFactory(), authyInstance, true, Integer.valueOf(0), (ObjectProvider)new DirectObjectProvider((Object)((MultifactorAuthenticationProvider)Mockito.mock(MultifactorAuthenticationProvider.class))));
    }
}

