/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.authy.web.flow;

import com.authy.AuthyApiClient;
import com.authy.api.Error;
import com.authy.api.Hash;
import com.authy.api.Token;
import com.authy.api.Tokens;
import com.authy.api.User;
import com.authy.api.Users;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apereo.cas.adaptors.authy.AuthyClientInstance;
import org.apereo.cas.adaptors.authy.web.flow.AuthyAuthenticationRegistrationWebflowAction;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="WebflowMfaActions")
public class AuthyAuthenticationRegistrationWebflowActionTests {
    @Test
    public void verifyOperation() throws Exception {
        AuthyClientInstance authyInstance = (AuthyClientInstance)Mockito.mock(AuthyClientInstance.class);
        AuthyApiClient apiClient = (AuthyApiClient)Mockito.mock(AuthyApiClient.class);
        Mockito.when((Object)authyInstance.authyClient()).thenReturn((Object)apiClient);
        Tokens tokens = (Tokens)Mockito.mock(Tokens.class);
        Token token = new Token(200, "OK", "Token is valid.");
        Mockito.when((Object)tokens.verify(Mockito.eq((int)123456), (String)Mockito.eq((Object)"token"), Mockito.anyMap())).thenReturn((Object)token);
        Mockito.when((Object)apiClient.getTokens()).thenReturn((Object)tokens);
        User user = new User(200, "token");
        user.setId(123456);
        Mockito.when((Object)authyInstance.getOrCreateUser((Principal)Mockito.any(Principal.class))).thenReturn((Object)user);
        Hash hash = new Hash(200, "OK");
        hash.setSuccess(true);
        hash.setUser(user);
        Users users = (Users)Mockito.mock(Users.class);
        Mockito.when((Object)users.requestSms(Mockito.anyInt())).thenReturn((Object)hash);
        Mockito.when((Object)apiClient.getUsers()).thenReturn((Object)users);
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        WebUtils.putAuthentication((Authentication)CoreAuthenticationTestUtils.getAuthentication(), (RequestContext)context);
        AuthyAuthenticationRegistrationWebflowAction action = new AuthyAuthenticationRegistrationWebflowAction(authyInstance);
        Event event = action.doExecute((RequestContext)context);
        Assertions.assertEquals((Object)"success", (Object)event.getId());
        user.setStatus(400);
        event = action.doExecute((RequestContext)context);
        Assertions.assertEquals((Object)"error", (Object)event.getId());
        user.setStatus(200);
        hash.setSuccess(false);
        hash.setError(new Error());
        hash.setMessage("Message");
        event = action.doExecute((RequestContext)context);
        Assertions.assertEquals((Object)"error", (Object)event.getId());
    }
}

