/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.authy.web.flow;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import org.apereo.cas.adaptors.authy.AuthyTokenCredential;
import org.apereo.cas.adaptors.authy.BaseAuthyAuthenticationTests;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.message.MessageContext;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockParameterMap;

@Tag(value="WebflowEvents")
@SpringBootTest(classes={BaseAuthyAuthenticationTests.SharedTestConfiguration.class}, properties={"cas.authn.mfa.authy.api-key=example", "cas.authn.mfa.authy.api-url=http://localhost:8080/authy"})
public class AuthyAuthenticationWebflowEventResolverTests {
    private final RequestContext context = (RequestContext)Mockito.mock(RequestContext.class);
    @Autowired
    @Qualifier(value="authyAuthenticationWebflowEventResolver")
    private CasWebflowEventResolver resolver;

    @BeforeEach
    public void beforeAll() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        Mockito.when((Object)this.context.getMessageContext()).thenReturn((Object)((MessageContext)Mockito.mock(MessageContext.class)));
        Mockito.when((Object)this.context.getConversationScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)this.context.getFlowScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)this.context.getRequestParameters()).thenReturn((Object)new MockParameterMap());
        Mockito.when((Object)this.context.getRequestScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)this.context.getFlashScope()).thenReturn((Object)new LocalAttributeMap());
        ServletExternalContext external = new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response);
        Mockito.when((Object)this.context.getExternalContext()).thenReturn((Object)external);
        RequestContextHolder.setRequestContext((RequestContext)this.context);
        ExternalContextHolder.setExternalContext((ExternalContext)external);
        WebUtils.putCredential((RequestContext)this.context, (Credential)new AuthyTokenCredential("token"));
    }

    @Test
    public void verifyOperation() {
        Authentication authn = RegisteredServiceTestUtils.getAuthentication((String)"casuser");
        AuthenticationResultBuilder builder = (AuthenticationResultBuilder)Mockito.mock(AuthenticationResultBuilder.class);
        Mockito.when((Object)builder.getInitialAuthentication()).thenReturn(Optional.of(authn));
        Mockito.when((Object)builder.collect((Authentication)Mockito.any(Authentication.class))).thenReturn((Object)builder);
        WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)builder, (RequestContext)this.context);
        WebUtils.putAuthentication((Authentication)authn, (RequestContext)this.context);
        Event event = this.resolver.resolveSingle(this.context);
        Assertions.assertEquals((Object)"error", (Object)event.getId());
        EventFactorySupport support = new EventFactorySupport();
        Assertions.assertTrue((boolean)event.getAttributes().contains(support.getExceptionAttributeName()));
    }
}

