/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aws;

import org.apereo.cas.aws.AmazonClientConfigurationBuilder;
import org.apereo.cas.configuration.model.support.aws.BaseAmazonWebServicesProperties;
import org.apereo.cas.configuration.model.support.dynamodb.AbstractDynamoDbProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.core.client.builder.SdkSyncClientBuilder;
import software.amazon.awssdk.http.SdkHttpClient;

@Tag(value="AmazonWebServices")
class AmazonClientConfigurationBuilderTests {
    AmazonClientConfigurationBuilderTests() {
    }

    @Test
    void verifyOperation() throws Throwable {
        AbstractDynamoDbProperties properties = new AbstractDynamoDbProperties(){
            private static final long serialVersionUID = -3599433486448467450L;
        };
        properties.setLocalAddress("github.com");
        properties.setEndpoint("http://localhost:4532");
        properties.setProxyHost("http://localhost:8080");
        SampleClientBuilder httpClientBuilder = (SampleClientBuilder)Mockito.mock(SampleClientBuilder.class);
        AwsSyncClientBuilder clientBuilder = (AwsSyncClientBuilder)Mockito.mock(AwsSyncClientBuilder.class);
        Mockito.when((Object)clientBuilder.httpClientBuilder((SdkHttpClient.Builder)Mockito.any())).thenReturn((Object)httpClientBuilder);
        Assertions.assertDoesNotThrow(() -> AmazonClientConfigurationBuilderTests.lambda$verifyOperation$0(clientBuilder, properties));
    }

    private static /* synthetic */ AwsSyncClientBuilder lambda$verifyOperation$0(AwsSyncClientBuilder clientBuilder, 1 properties) throws Throwable {
        return AmazonClientConfigurationBuilder.prepareSyncClientBuilder((AwsSyncClientBuilder)clientBuilder, (AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)"key", (String)"secret")), (BaseAmazonWebServicesProperties)properties);
    }

    private static interface SampleClientBuilder
    extends AwsClientBuilder,
    AwsSyncClientBuilder,
    SdkSyncClientBuilder {
    }
}

