/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aws;

import org.apereo.cas.aws.AmazonEnvironmentAwareClientBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.core.env.Environment;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.SdkSystemSetting;

@SpringBootTest(classes={RefreshAutoConfiguration.class})
@Tag(value="AmazonWebServices")
class AmazonEnvironmentAwareClientBuilderTests {
    @Autowired
    private Environment environment;

    AmazonEnvironmentAwareClientBuilderTests() {
    }

    @Test
    void verifyAction() throws Throwable {
        AmazonEnvironmentAwareClientBuilder builder = new AmazonEnvironmentAwareClientBuilder("aws", this.environment);
        AwsClientBuilder mock = (AwsClientBuilder)Mockito.mock(AwsClientBuilder.class);
        Mockito.when((Object)mock.build()).thenReturn(new Object());
        Object client = builder.build(mock, Object.class);
        Assertions.assertNotNull((Object)client);
        Assertions.assertNotNull((Object)builder.getSetting("secretAccessKey"));
        Assertions.assertNotNull((Object)builder.getSetting("secretAccessKey", String.class));
        Assertions.assertNotNull((Object)builder.getSetting("something", "defaultValue"));
    }

    static {
        System.setProperty(SdkSystemSetting.AWS_ACCESS_KEY_ID.property(), "AKIAIPPIGGUNIO74C63Z");
        System.setProperty(SdkSystemSetting.AWS_SECRET_ACCESS_KEY.property(), "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");
    }
}

