/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aws;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.aws.AmazonSecurityTokenServiceEndpoint;
import org.apereo.cas.config.AmazonCoreConfiguration;
import org.apereo.cas.config.CasAuthenticationEventExecutionPlanTestConfiguration;
import org.apereo.cas.config.CasCoreRestConfiguration;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.web.report.AbstractCasEndpointTests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Tag(value="AmazonWebServices")
@EnabledIfListeningOnPort(port={4566})
class AmazonSecurityTokenServiceEndpointTests {
    AmazonSecurityTokenServiceEndpointTests() {
    }

    @Nested
    @Tag(value="AmazonWebServices")
    @TestPropertySource(properties={"cas.amazon-sts.principal-attribute-name=awsroles", "cas.amazon-sts.principal-attribute-value=arn.+", "cas.amazon-sts.rbac-enabled=true", "cas.authn.attribute-repository.stub.attributes.awsroles=arn:aws:iam::223873472255:role/adminuser-iam-role,arn:aws:iam::123873472251:role/superuser-iam-role"})
    class WithMultipleRolesRequest
    extends BaseAmazonSecurityTokenServiceEndpointTests {
        @Autowired
        @Qualifier(value="awsSecurityTokenServiceEndpoint")
        private AmazonSecurityTokenServiceEndpoint awsSecurityTokenServiceEndpoint;
        @Autowired
        private ConfigurableApplicationContext applicationContext;

        WithMultipleRolesRequest(AmazonSecurityTokenServiceEndpointTests this$0) {
        }

        @BeforeEach
        public void beforeEach() {
            ApplicationContextProvider.holdApplicationContext((ApplicationContext)this.applicationContext);
            TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext);
        }

        @Test
        void verifyOperation() throws Throwable {
            MockHttpServletRequest request = new MockHttpServletRequest();
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.put((Object)"username", List.of("casuser"));
            body.put((Object)"password", List.of("resusac"));
            ResponseEntity credentials = this.awsSecurityTokenServiceEndpoint.fetchCredentials(null, null, null, null, (MultiValueMap)body, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            Assertions.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)credentials.getStatusCode());
        }

        @Test
        void verifySpecificUnknownRoleOperation() throws Throwable {
            MockHttpServletRequest request = new MockHttpServletRequest();
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.put((Object)"username", List.of("casuser"));
            body.put((Object)"password", List.of("resusac"));
            ResponseEntity credentials = this.awsSecurityTokenServiceEndpoint.fetchCredentials(null, null, null, "this-is-unknown-role", (MultiValueMap)body, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            Assertions.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)credentials.getStatusCode());
        }
    }

    @Nested
    @Tag(value="AmazonWebServices")
    @TestPropertySource(properties={"cas.amazon-sts.principal-attribute-name=awsroles", "cas.amazon-sts.principal-attribute-value=.+", "cas.amazon-sts.rbac-enabled=true", "cas.authn.attribute-repository.stub.attributes.awsroles=arn:aws:iam::223873472255:role/adminuser-iam-role"})
    class WithRoleRequest
    extends BaseAmazonSecurityTokenServiceEndpointTests {
        @Autowired
        @Qualifier(value="awsSecurityTokenServiceEndpoint")
        private AmazonSecurityTokenServiceEndpoint awsSecurityTokenServiceEndpoint;
        @Autowired
        private ConfigurableApplicationContext applicationContext;

        WithRoleRequest(AmazonSecurityTokenServiceEndpointTests this$0) {
        }

        @BeforeEach
        public void beforeEach() {
            ApplicationContextProvider.holdApplicationContext((ApplicationContext)this.applicationContext);
            TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext);
        }

        @Test
        void verifyOperation() throws Throwable {
            MockHttpServletRequest request = new MockHttpServletRequest();
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.put((Object)"username", List.of("casuser"));
            body.put((Object)"password", List.of("resusac"));
            ResponseEntity credentials = this.awsSecurityTokenServiceEndpoint.fetchCredentials(null, null, null, null, (MultiValueMap)body, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            Assertions.assertEquals((Object)HttpStatus.OK, (Object)credentials.getStatusCode());
        }
    }

    @Nested
    @Tag(value="AmazonWebServices")
    @TestPropertySource(properties={"cas.amazon-sts.principal-attribute-name=", "cas.amazon-sts.principal-attribute-value="})
    class WithoutAuthorizationAttributes
    extends BaseAmazonSecurityTokenServiceEndpointTests {
        @Autowired
        @Qualifier(value="awsSecurityTokenServiceEndpoint")
        private AmazonSecurityTokenServiceEndpoint awsSecurityTokenServiceEndpoint;
        @Autowired
        private ConfigurableApplicationContext applicationContext;

        WithoutAuthorizationAttributes(AmazonSecurityTokenServiceEndpointTests this$0) {
        }

        @BeforeEach
        public void beforeEach() {
            ApplicationContextProvider.holdApplicationContext((ApplicationContext)this.applicationContext);
            TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext);
        }

        @Test
        void verifyOperation() throws Throwable {
            MockHttpServletRequest request = new MockHttpServletRequest();
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.put((Object)"username", List.of("casuser"));
            body.put((Object)"password", List.of("resusac"));
            ResponseEntity credentials = this.awsSecurityTokenServiceEndpoint.fetchCredentials(null, null, null, null, (MultiValueMap)body, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            Assertions.assertEquals((Object)HttpStatus.OK, (Object)credentials.getStatusCode());
        }

        @Test
        void verifyContextValidationFails() throws Throwable {
            MockHttpServletRequest request = new MockHttpServletRequest();
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.put((Object)"username", List.of("test1234"));
            body.put((Object)"password", List.of("4321tset"));
            ResponseEntity status = this.awsSecurityTokenServiceEndpoint.fetchCredentials(null, null, null, null, (MultiValueMap)body, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            Assertions.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)status.getStatusCode());
        }

        @Test
        void verifyNoCredentials() throws Throwable {
            MockHttpServletRequest request = new MockHttpServletRequest();
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            ResponseEntity status = this.awsSecurityTokenServiceEndpoint.fetchCredentials(null, null, null, null, (MultiValueMap)body, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            Assertions.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)status.getStatusCode());
        }

        @Test
        void verifyFailsAuthN() throws Throwable {
            MockHttpServletRequest request = new MockHttpServletRequest();
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.put((Object)"username", List.of("casuser"));
            body.put((Object)"password", List.of("bad-password"));
            ResponseEntity status = this.awsSecurityTokenServiceEndpoint.fetchCredentials(null, null, null, null, (MultiValueMap)body, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            Assertions.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)status.getStatusCode());
        }
    }

    @Nested
    @Tag(value="AmazonWebServices")
    @TestPropertySource(properties={"cas.amazon-sts.principal-attribute-name=unknown"})
    class WithMissingAuthorizationAttributes
    extends BaseAmazonSecurityTokenServiceEndpointTests {
        @Autowired
        @Qualifier(value="awsSecurityTokenServiceEndpoint")
        private AmazonSecurityTokenServiceEndpoint awsSecurityTokenServiceEndpoint;
        @Autowired
        private ConfigurableApplicationContext applicationContext;

        WithMissingAuthorizationAttributes(AmazonSecurityTokenServiceEndpointTests this$0) {
        }

        @BeforeEach
        public void beforeEach() {
            ApplicationContextProvider.holdApplicationContext((ApplicationContext)this.applicationContext);
            TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext);
        }

        @Test
        void verifyAuthzFails() throws Throwable {
            MockHttpServletRequest request = new MockHttpServletRequest();
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.put((Object)"username", List.of("casuser"));
            body.put((Object)"password", List.of("resusac"));
            ResponseEntity status = this.awsSecurityTokenServiceEndpoint.fetchCredentials(null, null, null, null, (MultiValueMap)body, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            Assertions.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)status.getStatusCode());
        }
    }

    @Nested
    @Tag(value="AmazonWebServices")
    @TestPropertySource(properties={"cas.amazon-sts.principal-attribute-name=groupMembership", "cas.amazon-sts.principal-attribute-value=^un[A-Z]known.*", "cas.authn.attribute-repository.stub.attributes.groupMembership=some-value"})
    class WithMissingAuthorizationAttributeValues
    extends BaseAmazonSecurityTokenServiceEndpointTests {
        @Autowired
        @Qualifier(value="awsSecurityTokenServiceEndpoint")
        private AmazonSecurityTokenServiceEndpoint awsSecurityTokenServiceEndpoint;
        @Autowired
        private ConfigurableApplicationContext applicationContext;

        WithMissingAuthorizationAttributeValues(AmazonSecurityTokenServiceEndpointTests this$0) {
        }

        @BeforeEach
        public void beforeEach() {
            ApplicationContextProvider.holdApplicationContext((ApplicationContext)this.applicationContext);
            TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext);
        }

        @Test
        void verifyAuthzFails() throws Throwable {
            MockHttpServletRequest request = new MockHttpServletRequest();
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.put((Object)"username", List.of("casuser"));
            body.put((Object)"password", List.of("resusac"));
            ResponseEntity status = this.awsSecurityTokenServiceEndpoint.fetchCredentials(null, null, null, null, (MultiValueMap)body, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            Assertions.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)status.getStatusCode());
        }
    }

    @TestPropertySource(properties={"cas.amazon-sts.endpoint=http://127.0.0.1:4566", "cas.amazon-sts.region=us-east-1", "cas.amazon-sts.credential-access-key=test", "cas.amazon-sts.credential-secret-key=test", "cas.authn.mfa.groovy-script.location=classpath:AmazonStsGroovyMfa.groovy", "management.endpoint.awsSts.enabled=true"})
    @Import(value={AmazonCoreConfiguration.class, CasCoreRestConfiguration.class, CasAuthenticationEventExecutionPlanTestConfiguration.class})
    static class BaseAmazonSecurityTokenServiceEndpointTests
    extends AbstractCasEndpointTests {
        BaseAmazonSecurityTokenServiceEndpointTests() {
        }
    }
}

