/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.aws.authz.AmazonVerifiedPermissionsRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import software.amazon.awssdk.core.SdkSystemSetting;

@Tag(value="AmazonWebServices")
class AmazonVerifiedPermissionsRegisteredServiceAccessStrategyTests {
    private static final File JSON_FILE;
    private static final ObjectMapper MAPPER;

    AmazonVerifiedPermissionsRegisteredServiceAccessStrategyTests() {
    }

    @Test
    void verifySerializeToJson() throws IOException {
        AmazonVerifiedPermissionsRegisteredServiceAccessStrategy strategy = new AmazonVerifiedPermissionsRegisteredServiceAccessStrategy();
        strategy.setActionId("read");
        strategy.setCredentialAccessKey(UUID.randomUUID().toString());
        strategy.setCredentialSecretKey(UUID.randomUUID().toString());
        strategy.setPolicyStoreId("123456");
        strategy.setRegion("us-east-1");
        strategy.setContext(CollectionUtils.wrap((String)"key1", (Object)"value1"));
        MAPPER.writeValue(JSON_FILE, (Object)strategy);
        AmazonVerifiedPermissionsRegisteredServiceAccessStrategy read = (AmazonVerifiedPermissionsRegisteredServiceAccessStrategy)MAPPER.readValue(JSON_FILE, AmazonVerifiedPermissionsRegisteredServiceAccessStrategy.class);
        Assertions.assertEquals((Object)strategy, (Object)read);
    }

    @Test
    void verifyOperation() throws Throwable {
        AmazonVerifiedPermissionsRegisteredServiceAccessStrategy strategy = new AmazonVerifiedPermissionsRegisteredServiceAccessStrategy();
        strategy.setActionId("read");
        RegisteredServiceAccessStrategyRequest accessRequest = RegisteredServiceAccessStrategyRequest.builder().principalId("casuser").registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService()).service((Service)RegisteredServiceTestUtils.getService()).attributes(CollectionUtils.wrap((String)"key1", Set.of("value1"))).build();
        Assertions.assertFalse((boolean)strategy.authorizeRequest(accessRequest));
    }

    static {
        System.setProperty(SdkSystemSetting.AWS_ACCESS_KEY_ID.property(), "AKIAIPPIGGUNIO74C63Z");
        System.setProperty(SdkSystemSetting.AWS_SECRET_ACCESS_KEY.property(), "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");
        JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "AmazonVerifiedPermissionsRegisteredServiceAccessStrategyTests.json");
        MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    }
}

