/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class BasicAuthenticationWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    static final String STATE_ID_BASIC_AUTHENTICATION_CHECK = "basicAuthenticationCheck";

    public BasicAuthenticationWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            ActionState actionState = this.createActionState(flow, STATE_ID_BASIC_AUTHENTICATION_CHECK, (Action)this.createEvaluateAction("basicAuthenticationAction"));
            TransitionSet transitionSet = actionState.getTransitionSet();
            transitionSet.add(this.createTransition("success", "createTicketGrantingTicket"));
            transitionSet.add(this.createTransition("warn", "warn"));
            actionState.getExitActionList().add((Action)this.createEvaluateAction("clearWebflowCredentialsAction"));
            this.createStateDefaultTransition((TransitionableState)actionState, this.getStartState(flow).getId());
            this.setStartState(flow, (TransitionableState)actionState);
        }
    }
}

