/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.config;

import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.BasicAuthenticationAction;
import org.apereo.cas.web.flow.BasicAuthenticationCasMultifactorWebflowCustomizer;
import org.apereo.cas.web.flow.BasicAuthenticationWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.Authentication, module="basic")
@AutoConfiguration
public class CasBasicAuthenticationConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"basicAuthenticationAction"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public Action basicAuthenticationAction(@Qualifier(value="adaptiveAuthenticationPolicy") AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, @Qualifier(value="serviceTicketRequestWebflowEventResolver") CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver") CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver) {
        return new BasicAuthenticationAction(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy);
    }

    @ConditionalOnMissingBean(name={"basicAuthenticationWebflowConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasWebflowConfigurer basicAuthenticationWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
        return new BasicAuthenticationWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    @ConditionalOnMissingBean(name={"basicPrincipalFactory"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PrincipalFactory basicPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"basicCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer basicCasWebflowExecutionPlanConfigurer(@Qualifier(value="basicAuthenticationWebflowConfigurer") CasWebflowConfigurer basicAuthenticationWebflowConfigurer) {
        return plan -> plan.registerWebflowConfigurer(basicAuthenticationWebflowConfigurer);
    }

    @Bean
    @ConditionalOnMissingBean(name={"basicAuthenticationCasMultifactorWebflowCustomizer"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasMultifactorWebflowCustomizer basicAuthenticationCasMultifactorWebflowCustomizer() {
        return new BasicAuthenticationCasMultifactorWebflowCustomizer();
    }
}

