/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.consent.ConsentRepository;
import org.apereo.cas.consent.JpaConsentDecision;
import org.apereo.cas.consent.JpaConsentRepository;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.util.CollectionUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration(value="casConsentJdbcConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=true)
public class CasConsentJdbcConfiguration {
    @Autowired
    @Qualifier(value="jpaBeanFactory")
    private ObjectProvider<JpaBeanFactory> jpaBeanFactory;
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    public ConsentRepository consentRepository() {
        return new JpaConsentRepository();
    }

    @RefreshScope
    @Bean
    public JpaVendorAdapter jpaConsentVendorAdapter() {
        return ((JpaBeanFactory)this.jpaBeanFactory.getObject()).newJpaVendorAdapter(this.casProperties.getJdbc());
    }

    @Bean
    public DataSource dataSourceConsent() {
        return JpaBeans.newDataSource((AbstractJpaProperties)this.casProperties.getConsent().getJpa());
    }

    @Bean
    public List<String> jpaConsentPackagesToScan() {
        return CollectionUtils.wrapList((Object[])new String[]{JpaConsentDecision.class.getPackage().getName()});
    }

    @Lazy
    @Bean
    public LocalContainerEntityManagerFactoryBean consentEntityManagerFactory() {
        JpaBeanFactory factory = (JpaBeanFactory)this.jpaBeanFactory.getObject();
        JpaConfigurationContext ctx = new JpaConfigurationContext(this.jpaConsentVendorAdapter(), "jpaConsentContext", this.jpaConsentPackagesToScan(), this.dataSourceConsent());
        return factory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)this.casProperties.getConsent().getJpa());
    }

    @Autowired
    @Bean
    public PlatformTransactionManager transactionManagerConsent(@Qualifier(value="consentEntityManagerFactory") EntityManagerFactory emf) {
        JpaTransactionManager mgmr = new JpaTransactionManager();
        mgmr.setEntityManagerFactory(emf);
        return mgmr;
    }
}

