/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.consent;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.consent.ConsentDecision;
import org.apereo.cas.consent.ConsentRepository;
import org.apereo.cas.consent.JpaConsentDecision;
import org.apereo.cas.services.RegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;

@EnableTransactionManagement(proxyTargetClass=true)
@Transactional(transactionManager="transactionManagerConsent")
public class JpaConsentRepository
implements ConsentRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaConsentRepository.class);
    private static final long serialVersionUID = 6599902742493270206L;
    private static final String SELECT_QUERY = "SELECT r from JpaConsentDecision r ";
    @PersistenceContext(unitName="consentEntityManagerFactory")
    private transient EntityManager entityManager;

    public ConsentDecision findConsentDecision(Service service, RegisteredService registeredService, Authentication authentication) {
        try {
            String query = SELECT_QUERY.concat("WHERE r.principal = :principal AND r.service = :service");
            return (ConsentDecision)this.entityManager.createQuery(query, JpaConsentDecision.class).setParameter("principal", (Object)authentication.getPrincipal().getId()).setParameter("service", (Object)service.getId()).getSingleResult();
        }
        catch (NoResultException e) {
            LOGGER.debug(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return null;
    }

    public Collection<? extends ConsentDecision> findConsentDecisions(String principal) {
        try {
            return this.entityManager.createQuery(SELECT_QUERY.concat("where r.principal = :principal"), JpaConsentDecision.class).setParameter("principal", (Object)principal).getResultList();
        }
        catch (NoResultException e) {
            LOGGER.debug(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return new ArrayList(0);
    }

    public Collection<? extends ConsentDecision> findConsentDecisions() {
        try {
            return this.entityManager.createQuery(SELECT_QUERY, JpaConsentDecision.class).getResultList();
        }
        catch (NoResultException e) {
            LOGGER.debug(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return new ArrayList(0);
    }

    public boolean storeConsentDecision(ConsentDecision decision) {
        try {
            JpaConsentDecision account = new JpaConsentDecision();
            account.setId(decision.getId());
            account.setAttributes(decision.getAttributes());
            account.setCreatedDate(decision.getCreatedDate());
            account.setOptions(decision.getOptions());
            account.setPrincipal(decision.getPrincipal());
            account.setReminder(decision.getReminder());
            account.setReminderTimeUnit(decision.getReminderTimeUnit());
            account.setService(decision.getService());
            boolean isNew = account.getId() < 0L;
            JpaConsentDecision mergedDecision = (JpaConsentDecision)((Object)this.entityManager.merge((Object)account));
            if (!isNew) {
                this.entityManager.persist((Object)mergedDecision);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean deleteConsentDecision(long decisionId, String principal) {
        try {
            JpaConsentDecision decision = (JpaConsentDecision)((Object)this.entityManager.createQuery(SELECT_QUERY.concat("WHERE r.id = :id"), JpaConsentDecision.class).setParameter("id", (Object)decisionId).getSingleResult());
            this.entityManager.remove((Object)decision);
            return true;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Generated
    public String toString() {
        return "JpaConsentRepository(entityManager=" + this.entityManager + ")";
    }
}

