/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.consent.ConsentProperties;
import org.apereo.cas.consent.ConsentDecision;
import org.apereo.cas.consent.ConsentEngine;
import org.apereo.cas.consent.ConsentReminderOptions;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractConsentAction
extends AbstractAction {
    protected final CasConfigurationProperties casProperties;
    protected final ServicesManager servicesManager;
    protected final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    protected final ConsentEngine consentEngine;

    protected RegisteredService getRegisteredServiceForConsent(RequestContext requestContext, Service service) {
        Service serviceToUse = this.authenticationRequestServiceSelectionStrategies.resolveService(service);
        RegisteredService registeredService = this.servicesManager.findServiceBy(serviceToUse);
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
        return registeredService;
    }

    protected void prepareConsentForRequestContext(RequestContext requestContext) {
        ConsentProperties consentProperties = this.casProperties.getConsent();
        WebApplicationService originalService = WebUtils.getService((RequestContext)requestContext);
        Service service = this.authenticationRequestServiceSelectionStrategies.resolveService((Service)originalService);
        RegisteredService registeredService = this.getRegisteredServiceForConsent(requestContext, service);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Map attributes = this.consentEngine.resolveConsentableAttributesFrom(authentication, service, registeredService);
        MutableAttributeMap flowScope = requestContext.getFlowScope();
        flowScope.put("attributes", (Object)attributes);
        WebUtils.putPrincipal((RequestContext)requestContext, (Principal)authentication.getPrincipal());
        WebUtils.putServiceIntoFlashScope((RequestContext)requestContext, (Service)service);
        ConsentDecision decision = this.consentEngine.findConsentDecision(service, registeredService, authentication);
        flowScope.put("option", (Object)Optional.ofNullable(decision).map(consentDecision -> consentDecision.getOptions().getValue()).orElseGet(() -> ((ConsentReminderOptions)ConsentReminderOptions.ATTRIBUTE_NAME).getValue()));
        long reminder = decision == null ? consentProperties.getReminder() : decision.getReminder().longValue();
        flowScope.put("reminder", (Object)reminder);
        flowScope.put("reminderTimeUnit", (Object)Optional.ofNullable(decision).map(consentDecision -> consentDecision.getReminderTimeUnit().name()).orElseGet(() -> consentProperties.getReminderTimeUnit().name()));
    }

    @Generated
    public AbstractConsentAction(CasConfigurationProperties casProperties, ServicesManager servicesManager, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, ConsentEngine consentEngine) {
        this.casProperties = casProperties;
        this.servicesManager = servicesManager;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
        this.consentEngine = consentEngine;
    }
}

